#version 150

out vec4 fragColor;

in vec3 normal;
in vec3 dir;
in vec2 uv;

uniform samplerCube cube1;
uniform samplerCube cube2;
uniform sampler2D diffuse;
uniform float blend;

void main( void )
{
	vec3 ref = normalize(reflect(normalize(dir), normalize(normal)));
    
    vec4 c1 = texture(cube1, ref);
    vec4 c2 = texture(cube2, ref);
    vec4 diffuse = texture(diffuse, uv);
    
	fragColor = diffuse + mix(c1, c2, blend);
}
