#version 150

out vec4 fragColor;
uniform sampler2D image;
uniform float contrast;
uniform float brightness;
in vec2 uv;

float luminance(vec4 c)
{
	// Luminance (standard, objective): (0.2126*R) + (0.7152*G) + (0.0722*B)
	// Luminance (perceived option 1): (0.299*R + 0.587*G + 0.114*B)
	// Luminance (perceived option 2, slower to calculate): sqrt( 0.241*R^2 + 0.691*G^2 + 0.068*B^2 )
	return (0.2126 * c.r) + (0.7152 * c.g) + (0.0722 * c.b);
}

void main()
{
	vec4 color = texture(image, uv); 
	color.rgb *= luminance(color);
	color.rgb = ((color.rgb - 0.5) * max(contrast, 0.0)) + 0.5;
	color.rgb += brightness;
	fragColor = color;
}
