    MAC PLAQUE_LOGIC
PlaqueSolid
    lda #$0E
    bne PlaqueColorOK
PlaqueLogic
    lda rowbeat
    cmp #16
    bcc PlaqueColorOK

    lda rowbeat
    ldy #1
    sec
    sbc (rowptr),Y
    clc
    adc #16
    bmi PlaqueColorNope ;leave it alone
    eor #15
PlaqueColorOK
    sta COLUP0
    sta COLUP1
PlaqueColorNope

    ldy #2
    lda (rowptr),Y
    ;plaquechars = (arg >> 6)*12 = (arg & %11000000
    lsr
    lsr
    lsr
    sta plaquechars
    asr #%11000
    adc plaquechars
    adc #12
    sta plaquechars

    ;burnlines = 228 - 32 - (2*CHARH+15)*((arg >> 6)+1) = 228 - 32 - 39*((arg >> 6)+1)
    lda (rowptr),Y
    lsr
    lsr
    lsr
    lsr
    lsr
    lsr
    tay
    ldx #228-32-1
    lda #$FF
SetBurnLines
    sbx #39
    dey
    bpl SetBurnLines
    stx burnlines

    ;textptr = Text + 12*(arg & 63)
    lda #<Lines
    sta textptr
    lda #>Lines
    sta textptr+1
    ldy #2
    lda (rowptr),Y
    and #63
    tax
    beq DoneTextPtr
    lda #<Lines
TextPtrLoop
    clc
    adc #12
    bcc NoCarry
    inc textptr+1
NoCarry
    dex
    bne TextPtrLoop
    sta textptr
DoneTextPtr

    ldy #0
    ldx #0
LoadLine
    lda (textptr),Y
    and #%11111100
    sta charptr+0,X
    lda (textptr),Y
    and #%00000011
    clc
    adc #>Font
    sta charptr+1,X
    inx
    inx
    iny
    cpy plaquechars
    bne LoadLine

    lda #%1110
    sta NUSIZ0
    sta NUSIZ1

    lda #1
    sta CTRLPF
    sta COLUBK

TEXTX   equ 35
    lda #TEXTX
    ldx #0
    jsr PositionObject
    lda #TEXTX+16
    inx
    stx VDELP0
    stx VDELP1
    jmp PositionObject  ;tail recursion
    ENDM

    MAC PLAQUE_KERNEL
PlaqueKernel
    lda #%11000000
    sta PF0

    ;draw three lines
    ldy #2
    lda (rowptr),Y
    lsr
    lsr
    lsr
    lsr
    lsr
    lsr
    sta temp

    ldy #0
    jsr PlaqueBar

BURNSHIFT   equ 6
    lda burnlines
    lsr
    adc #BURNSHIFT
    tax
    jsr Burn

NextLine
    ldy #CHARH-1
PlaqueKernelLoop
    lda #$80
    sta HMP0
    sta HMP1

    sta WSYNC
    sta HMOVE           ;right 8 pixels

    SLEEP 5

    lda (charptr+2),Y
    sta GRP0
    lda (charptr+6),Y
    sta GRP1
    lda (charptr+10),Y
    sta GRP0
    lda (charptr+14),Y
    sta GRP1
    lda (charptr+18),Y
    sta GRP0
    lda (charptr+22),Y
    sta GRP1
    sta GRP0

    SLEEP 8

    sta HMCLR   ;I found a video that explains how this works:
    sta HMOVE   ;http://www.youtube.com/watch?v=x0yQg8kHVcI

    SLEEP 6

    lda (charptr+0),Y
    sta GRP0
    lda (charptr+4),Y
    sta GRP1
    lda (charptr+8),Y
    sta GRP0
    lda (charptr+12),Y
    sta GRP1
    lda (charptr+16),Y
    sta GRP0
    lda (charptr+20),Y
    sta GRP1
    sta GRP0

    dey
    bpl PlaqueKernelLoop
    CHECK_ALIGN PlaqueKernelLoop

    ;shift pointers
    ldx #0
    stx GRP0
    stx GRP1
    stx GRP0
ShiftLinePointers
    lda charptr+24,X
    sta charptr+0,X
    inx
    cpx #72
    bne ShiftLinePointers

    dec temp
    bpl NextLine

    lda burnlines
    lsr
    sec
    sbc #BURNSHIFT
    tax
    jsr Burn

    ldy #$0F
    jsr PlaqueBar
    sta COLUPF      ;gets rid of the ugliness in the lower left

    brk

PlaqueBar
    lda #$FF
    sta PF1
    sta PF2
    sty temp+3
    ldx #15
PlaqueBarLoop
    txa
    eor temp+3
    asl
    and #%10
    sta temp+2
    txa
    eor temp+3
    ora temp+2
    ora #$40
    sta WSYNC
    sta COLUPF
    dex
    bpl PlaqueBarLoop
    lda #0
    sta PF1
    sta PF2
    rts

    ENDM
