#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "SDL/SDL.h"
#include "SDL/SDL_image.h"
#include "SDL/SDL_mixer.h"
#include "SDL/SDL_ttf.h"

#define WIDTH 640
#define HEIGHT 400

#define min(a,b) (((a) < (b)) ? (a) : (b))

SDL_Surface* intro;

SDL_Surface* face1;
SDL_Surface* face2;

float millis = 0;

///////////////////////////////////////////////////////////////////

void render(SDL_Surface *screen, float millis)
{

  int vamu = (int)millis;


  if (millis < 5000) SDL_BlitSurface(intro, NULL, screen, NULL);
  else if (millis >= 5000 && millis < 10200) {
    SDL_BlitSurface(face1, NULL, screen, NULL);
  }
  else if (millis > 10200 && millis < 11700) {
    if (cos(vamu*0.05) < 0.5)
    SDL_BlitSurface(face1, NULL, screen, NULL);
    else
    SDL_BlitSurface(face2, NULL, screen, NULL);
  }
  else if (millis > 16800 && millis < 18000) {
    if (cos(vamu*0.05) < 0.5)
    SDL_BlitSurface(face1, NULL, screen, NULL);
    else
    SDL_BlitSurface(face2, NULL, screen, NULL);
  }
}

/////////////////////////////////////////////////////////////// MAIN


main(int argc, char *argv[])
{
  SDL_Surface *screen;

  int done;
  SDL_Event event;
  Uint8 *keystate;

  /* Initialize SDL */
  if ( SDL_Init(SDL_INIT_VIDEO) < 0 )
  {
    fprintf(stderr, "Couldn't initialize SDL: %s\n", SDL_GetError());
    return 1;
  }
  atexit(SDL_Quit);

  if ( Mix_OpenAudio(44100, AUDIO_S16, 2, 512) < 0 )
  {
    fprintf(stderr, "Couldn't initialize SDL audio: %s\n", SDL_GetError());
    return 1;
  }

  Mix_Music* music = Mix_LoadMUS("data\\paskaiso.ogg");

  if ( music == NULL )
    fprintf(stderr, "Couldn't load music: %s\n", Mix_GetError());

  screen = SDL_SetVideoMode(WIDTH, HEIGHT, 32,
			(SDL_HWSURFACE|SDL_FULLSCREEN)); //
  if ( screen == NULL )
  {
    fprintf(stderr, "Couldn't init video mode: %s\n", SDL_GetError());
    return 1;
  }

  SDL_ShowCursor(0);

  IMG_Init(IMG_INIT_PNG);

  intro = IMG_Load("data\\intro.png");
  if ( intro == NULL )
  {
    return 1;
  }

  face1 = IMG_Load("data\\face1.png");
  if ( face1 == NULL )
  {
    return 1;
  }

  face2 = IMG_Load("data\\face2.png");
  if ( face2 == NULL )
  {
    return 1;
  }

  done=0;

  float t = 0.0;
  float dt = 1 / 60.0f;

  float currentTime = SDL_GetTicks();
  float deltaTime = 0.0;

  int frame = 0;

  while(!done)
  {
    if (!Mix_PlayingMusic())
      Mix_PlayMusic(music, 0);

    float newTime = SDL_GetTicks();
    float frameTime = newTime - currentTime;
    currentTime = newTime;
    millis+=frameTime;

    while (frameTime > 0.0f)
    {
      deltaTime = min(frameTime, dt);
      frameTime -= deltaTime;
      t += deltaTime;
    }

    // RENDER --------------------------------------
    /* Draw the frame */

    render(screen, millis);

    SDL_Flip(screen);

    frame++;

    if (millis > 22000) done = 1;

    /* User input */
    while ( SDL_PollEvent(&event) )
    {
      if ( event.type == SDL_QUIT )
      {
          done = 1;
      }
    }
    keystate = SDL_GetKeyState(NULL);
    if ( keystate[SDLK_ESCAPE] ) {
      done = 1;
    }
  }

  /* Exit to text mode */
  exit(0);
}
