#include "dmlib.h"
#include "dmvecmat.h"
#include "dmmutex.h"

void printTest(const char *test, int expected, int result)
{
    fprintf(stderr, "Test '%s': %s\n", test,
        expected == result ? "OK" : "FAILED!");
}

#define tst(X, R) printTest(# X, (X), (R))


void dm_vector_fprintf(FILE *f, const char *name, DMVector *v)
{
    if (name != NULL)
        fprintf(f, "%s=", name);

    fprintf(f, "[<%1.3f, %1.3f, %1.3f>=%1.3f]", v->x, v->y, v->z, dm_vector_length(v));

    if (name != NULL)
        fprintf(f, "\n");
}


void dm_vector_printf(const char *name, DMVector *v)
{
    dm_vector_fprintf(stdout, name, v);
}


void dm_matrix_fprintf(FILE *f, const char *name, DMMatrix *mat)
{
    int i, j, k, pad = 0;
    char *tmp = NULL;

    if (name != NULL)
    {
        tmp = dm_strdup_printf("%s=", name);
        pad = strlen(tmp);
    }

    for (i = 0; i < DM_MATRIX_SIZE; i++)
    {
        if (i == 1)
            fputs(tmp, f);
        else
            for (k = 0; k < pad; k++)
                fputc(' ', f);

        fprintf(f, "[");
        for (j = 0; j < DM_MATRIX_SIZE; j++)
            fprintf(f, "% 8.3f%s", mat->m[i][j], j < DM_MATRIX_SIZE - 1 ? " " : "");
        
        fprintf(f, "]\n");
    }
}


void dm_matrix_printf(const char *name, DMMatrix *mat)
{
    dm_matrix_fprintf(stdout, name, mat);
}


int main(int argc, char *argv[])
{
    DMVector a = { -5, 1, 17, 0 }, b = { 1, 2, 0.5, 0 };
    DMMatrix m;

    (void) argc;
    (void) argv;    

    dm_vector_printf("a", &a);
    dm_vector_printf("b", &a);
    
    dm_matrix_rot_a(&m, 0.5, 0.9, 0.1);
    dm_matrix_printf("m", &m);

    dm_vector_mul_by_mat(&b, &a, &m);
    
    dm_vector_printf("nb", &b);
    
    return 0;
}
