#!/bin/sh
ETEST="./evaltest -f -e"
CTEST=./frm

echo "
2 << 1 + 9 >> 3 * 5
(2 << 1 + 9)  >> 3 * 5
2 << 1 + 31 >> 3 * 5
5 << 1
8 << 3 * 5
3200/2 << 5
3200/(2 << 5)
15+5/3
(15+5)/3
5*-3
-64 + 5 << 3 * 3 - 1
-64 + 5 << 3 + 3 - 1
3 * -1 + 5 << 1
7 + 3 << 2 * 3
7 * 3 << 4 - 3
127&127 + 12&3
1+3*5&7
35&3 + 2
9+5&(3 + 7)
(5*(7&3) + 1)
123045 >> 1 & 60
~60
3 + ~5
-~128
5-~127
" | while read f; do
  if test "x$f" != "x"; then
     printf "#include <stdio.h>\nint main(int argc, char *argv[])\n{\n  (void) argc; (void) argv;\n  printf(\"%%1.5f\\\\n\", (double) (%s));\n  return 0;\n}\n" "$f" > "$CTEST.c"
     gcc -g -o "$CTEST" "$CTEST.c"
     if test $? -eq 0; then
       RES1=`$CTEST`
       RES2=`$ETEST "$f"`
       if test "$RES1" != "$RES2"; then
         echo "---------------------------------------------"
         echo "RESULT MISMATCH: '$f'"
         echo " C test: $RES1"
         echo "   eval: $RES2"
         cat "$CTEST.c"
       elif test "x$1" != "x"; then
         echo "---------------------------------------------"
         echo "FORMULA: '$f'"
         echo " C test: $RES1"
         echo "   eval: $RES2"
       fi
     fi
  fi
done
#rm -f "$CTEST" "$CTEST.c"
