/*
 * miniJSS - General functions
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2006-2007 Tecnic Software productions (TNSP)
 */
#include "jss.h"
#include <stdarg.h>


/* Memory and error handling functions
 */

BOOL jssWarningIsFatal, jssErrorIsFatal;

#ifndef JSS_LIGHT
void (*jssError) (int code, const char *filename, int linen, const char *fmt, ...);
void (*jssWarning) (int code, const char *filename, int linen, const char *fmt, ...);
#endif


void jssDefaultPrint(int code, const char *filename, int linen, const char *fmt)
{
    fprintf(stderr, "JSS");
    if (filename)
        fprintf(stderr, "[%s:%i]", filename, linen);
    fprintf(stderr, "%s", fmt);
    if (code > 0)
        fprintf(stderr, "(%i)", code);
    fprintf(stderr, ": ");
}


void jssDefaultError(int code, const char *filename, int linen, const char *fmt, ...)
{
    va_list ap;
    jssDefaultPrint(code, filename, linen, "E");

    va_start(ap, fmt);
    vfprintf(stderr, fmt, ap);
    va_end(ap);
}


void jssDefaultWarning(int code, const char *filename, int linen, const char *fmt, ...)
{
    va_list ap;
    jssDefaultPrint(code, filename, linen, "W");

    va_start(ap, fmt);
    vfprintf(stderr, fmt, ap);
    va_end(ap);
}


/* System initialization
 */
int jssInit(void)
{
    // Error handling
    jssWarningIsFatal = FALSE;
    jssErrorIsFatal = TRUE;

#ifndef JSS_LIGHT
    jssError = jssDefaultError;
    jssWarning = jssDefaultWarning;
#endif

    // Allocate global tables

    return DMERR_OK;
}


/* System shutdown
 */
int jssClose(void)
{
    return DMERR_OK;
}
