/*
 * miniJSS - Mixing routine in C, innerloop template
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2006-2007 Tecnic Software productions (TNSP)
 */

int JMIXER_NAME (JSSMixer *mixer, JSSChannel *chn, JMIXER_ADDBUF_TYPE *addBuffer, const int mixLength, const DMFixedPoint endPos)
#ifdef JMIXER_HEADER
;
#else
{
    const DMFixedPoint tmpDelta = chn->chDeltaO, tmpDeltaV = chn->chDeltaV;
    DMFixedPoint tmpPos = chn->chPos,
                 tmpVolume = chn->chVolume;
    JMIXER_ADDBUF_TYPE
        *ap = addBuffer,
        *tr = chn->chPrevR,
        *tl = chn->chPrevL;
    int strideLength = 0;
    (void) tr;
    (void) tl;

    JMIXER_SAMPLE_TYPE *sp = (JMIXER_SAMPLE_TYPE *) chn->chData;

    JMIXER_INIT

    if (chn->chVolumeD > 0)
    {
        const int tmpLength = chn->chVolumeD < mixLength ? chn->chVolumeD : mixLength;
        chn->chVolumeD -= tmpLength;

        while (strideLength < tmpLength && JMIXER_ENDCOND)
        {
            JMIXER_FUNC
            JMIXER_DEBUG
            JMIXER_NEXT
            FP_ADD(tmpVolume, tmpDeltaV);
            strideLength++;
        }
    }
    
    while (strideLength < mixLength && JMIXER_ENDCOND)
    {
        JMIXER_FUNC
        JMIXER_DEBUG
        JMIXER_NEXT
        strideLength++;
    }

    chn->chPos = tmpPos;
    chn->chVolume = tmpVolume;
    return strideLength;
}
#endif

#undef JMIXER_NAME
#undef JMIXER_NEXT
#undef JMIXER_ENDCOND

