//
// Demo Editor -- Timeline state object
// Wrapper class for DMTimeline data
// (C) Copyright 2012 Matti 'ccr' Hmlinen <ccr@tnsp.org>
//
#include "edtlobj.h"
#include "dmres.h"


EDTimelineObject::EDTimelineObject()
{
    dmTimelineNew(&tl, "Demo");
    scrub();
}


EDTimelineObject::EDTimelineObject(EDTimelineObject *obj)
{
    scrub();
    filename = obj->filename;
    dmCopyTimeline(obj->tl, &tl);
}


EDTimelineObject::~EDTimelineObject()
{
    dmFreeTimeline(tl);
}


int EDTimelineObject::load(QString mfilename)
{
    QByteArray fnba = mfilename.toUtf8();
    DMResource *res;
    DMTimeline *tmp;
    if ((res = dmf_create_stdio(fnba.data(), "rb")) == NULL)
        return DMERR_FOPEN;

    int err = dmLoadTimeline(res, &tmp);
    dmf_close(res);

    if (err == DMERR_OK)
    {
        dmFreeTimeline(tl);
        tl = tmp;
        scrub();
        if (tl->name != NULL)
            filename = QString(tl->name);
        else
            filename = mfilename;
    }
    else
    {
        dmFreeTimeline(tmp);
    }
    return err;
}


int EDTimelineObject::save(QString mfilename)
{
    QByteArray fnba = mfilename.toUtf8();
    DMResource *res;
    if ((res = dmf_create_stdio(fnba.data(), "wb")) == NULL)
        return DMERR_FOPEN;

    int err = dmSaveTimeline(res, tl);
    scrub();

    dmf_close(res);
    return err;
}


void EDTimelineObject::touch()
{
    ntouches++;
}


void EDTimelineObject::scrub()
{
    ntouches = 0;
}


bool EDTimelineObject::touched()
{
    return ntouches;
}


void EDTimelineObject::setState(const QString &mstate)
{
    cstate = mstate;
}


QString EDTimelineObject::state() const
{
    return cstate;
}
