#ifndef EDTIMELINE_H
#define EDTIMELINE_H

#include <QWidget>
#include <QCheckBox>
#include <QVBoxLayout>
#include <QLabel>
#include <QLineEdit>
#include "edtlobj.h"
#include "dmengine.h"


class QEDTimelineTrackDisplay : public QWidget
{
    Q_OBJECT

public:
    DMTimelineTrack *track;

    QEDTimelineTrackDisplay(QWidget *parent = 0);
    void setTrack(DMTimelineTrack *mtrack);

    float getTimeScale(float value);
    float getTimeFromCoord(float value);

    void setScale(const float mscale);

    bool getSelection(float *mstart, float *mduration);
    QList<DMTimelineEvent *> getEventsAt(const int time);
    QList<DMTimelineEvent *> getEventsForRange(const int start, const int duration);

    QSize minimumSizeHint() const;
    QSize sizeHint() const;

public slots:
    void setTime(const float mtime);
    void setOffset(const float moffs);
    void setSelection(const float mstart, const float mend);
    void clearSelection();

signals:
    void selectionChanged(float mstart, float mduration);
    void timeChanged(float value);
    void offsetChanged(float value);

protected:
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

    void paintEvent(QPaintEvent *event);

private:
    float scale, time, offs;

    bool selectionValid;
    float selectionStart, selectionDuration;

    QPoint selectionPoint, dragPoint;
    bool selecting, dragging;
    float selectionOffs, dragOffs;
};


class QEDTimelineTrackView : public QWidget
{
    Q_OBJECT

private:
    QLineEdit *infoName;
    QLabel *infoData;
    QCheckBox *enabledCheck;

public:
    QEDTimelineTrackDisplay *track;

    QEDTimelineTrackView(QWidget *parent = 0);
    void setTrack(DMTimelineTrack *mtrack);
    void update();

private slots:
    void slotTrackEnabledChanged(bool);
    void slotTrackNameChanged(const QString & text);

signals:
    void trackChanged();
    void selectionChanged(float mstart, float mduration);
    void timeChanged(float value);
    void offsetChanged(float value);
};


class QEDTimelineView : public QWidget
{
    Q_OBJECT

private:
    QVBoxLayout *layout;

    EDTimelineObject *tl;
    QList<QEDTimelineTrackView *> tracks;
    int activeTrack;

public:
    QEDTimelineView(QWidget *parent = 0);
    void setTimeline(EDTimelineObject *mtl);

    void setTime(const float mtime);
    void setOffset(const float moffs);
    void setScale(const float mscale);

private slots:
    void slotTimelineChanged();

signals:
    void timelineChanged();
    void timeChanged(float value);
    void offsetChanged(float value);
};

#endif
