/*
 * DMLib
 * -- Wav file writing
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2012 Tecnic Software productions (TNSP)
 */
#ifndef DMWAV_H
#define DMWAV_H

#include "dmlib.h"
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

#define DM_WAVE_FORMAT_PCM     (1)
#define DM_WAVE_RIFF_ID        "RIFF"
#define DM_WAVE_WAVE_ID        "WAVE"
#define DM_WAVE_FMT_ID         "fmt "
#define DM_WAVE_DATA_ID        "data"


typedef struct
{
    Uint8     chunkID[4];
    Uint32    chunkSize;
} DMWaveChunk; 


typedef struct
{
    Uint8     riffID[4];
    Uint32    fileSize;
    Uint8     riffType[4];

    DMWaveChunk chFormat;

    Uint16    wFormatTag;
    Uint16    nChannels;
    Uint32    nSamplesPerSec;
    Uint32    nAvgBytesPerSec;
    Uint16    nBlockAlign;
    Uint16    wBitsPerSample;

    DMWaveChunk chData;
    // Data follows here
} DMWaveFile;


BOOL dmWriteWAVChunk(FILE * f, DMWaveChunk *ch);
void dmMakeWAVChunk(DMWaveChunk *ch, const char *chunkID, const Uint32 chunkSize);
void dmWriteWAVHeader(FILE *outFile, int sampBits, int sampFreq, int sampChn, size_t sampLen);


#ifdef __cplusplus
}
#endif

#endif // DMWAV_H
