/*
 * DMLib
 * -- Whatever
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2012 Tecnic Software productions (TNSP)
 */
#ifndef DMQ3D_H
#define DMQ3D_H

#include "dmlib.h"
#include "dmvecmat.h"
#include "dmres.h"

#ifdef __cplusplus
extern "C" {
#endif


typedef struct
{
    int v1, v2, type;
} DM3DVector;


typedef struct
{
    int v, bitmap;
} DM3DSprite;


typedef struct
{
    char name[64];
    SDL_Surface *img;
} DM3DBitmap;


typedef struct
{
    int nvertices, nvertexalloc;
    DMVector *vertices;

    int nlines, nlinesalloc;
    DM3DVector *lines;

    int nbitmaps, nbitmapsalloc;
    DM3DBitmap *bitmaps;
    
    int nsprites, nspritesalloc;
    DM3DSprite *sprites;
} DM3DVectorSpriteModel;


int dmAdd3DVectorSpriteModelVertex(DM3DVectorSpriteModel *model, DMVector *v, int *index);
int dmAdd3DVectorSpriteModelVector(DM3DVectorSpriteModel *model, DM3DVector *v, int *index);
int dmAdd3DVectorSpriteModelSprite(DM3DVectorSpriteModel *model, DM3DSprite *v, int *index);
int dmAdd3DVectorSpriteModelBitmap(DM3DVectorSpriteModel *model, DM3DBitmap *v, int *index);

int dmRead3DVectorSpriteModel(DMResource *f, DM3DVectorSpriteModel **model);
void dmFree3DVectorSpriteModel(DM3DVectorSpriteModel *model);

void dmDraw3DVectorSpriteModel(SDL_Surface *screen, const DM3DVectorSpriteModel *model, const DMVector *pos, const DMMatrix *mat, SDL_Surface *fbmap, const Uint32 lcol);


#ifdef __cplusplus
}
#endif

#endif // DMQ3D_H
