/*
 * DMLib
 * -- PACK-file routines
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2011 Tecnic Software productions (TNSP)
 */
#ifndef DMPACK_H
#define DMPACK_H
#include "dmlib.h"


#define	DPACK_IDENT     "TNSPDPCK"      // Magic ident
#define	DPACK_VERSION   (0x0120)        // Version
#define	DPACK_TMPSIZE   (128 * 1024)


typedef struct _DMPackEntry
{
    char    filename[DMRES_NAME_LEN];
    Uint32  size;              // Size (UNCOMPRESSED)
    Uint32  offset;            // Offset in pack file
    Uint32  length;            // (Compressed) data length

    Uint32  flags, privFlags;
    
    struct _DMPackEntry *next, *prev;
} DMPackEntry;


typedef struct
{
    DMPackEntry *entries;
    char *  filename;          // Filename & path
    FILE *  file;              // File
} DMPackFile;


typedef struct
{
    char    ident[8];          // Magic identifier
    Uint16  version;           // Version
    Uint32  dirEntries;        // Number of entries
    Uint32  dirOffset;         // Offset of the directory
} DMPackFileHeader;


DMPackEntry *  dmPackEntryNew();
void           dmPackEntryFree(DMPackEntry *);
void           dmPackEntryInsert(DMPackEntry **, DMPackEntry *);
void           dmPackEntryDelete(DMPackEntry **, DMPackEntry *);

DMPackEntry *  dmPackFind(DMPackEntry *list, const char *filename);

int            dmPackOpen(const char *, DMPackFile **, BOOL);
int            dmPackClose(DMPackFile *);
int            dmPackRead(DMPackFile *, const char *, Uint8 **, size_t *);


#endif // DMPACK_H
