
#define DM_DRAWLINE_NAME dmDrawLine8
#define DM_DRAWLINE_DST_BYTES 1
#define DM_DRAWLINE_DST_TYPE Uint8
#define DM_DRAWLINE_INNER pix[y0 + x0] = col;
#include "dmdrawline.h"


#define DM_DRAWLINE_NAME dmDrawLine32
#define DM_DRAWLINE_DST_BYTES 4
#define DM_DRAWLINE_DST_TYPE Uint32
#define DM_DRAWLINE_INNER pix[y0 + x0] = col;
#include "dmdrawline.h"


#define DM_DRAWLINE_NAME dmDrawLine8Transparent
#define DM_DRAWLINE_DST_BYTES 1
#define DM_DRAWLINE_DST_TYPE Uint8
#define DM_DRAWLINE_INNER \
  pix[y0 + x0] = ((int)pix[y0 + x0] + col) >> 1;
#include "dmdrawline.h"


#define DM_DRAWLINE_NAME dmDrawLine32Transparent
#define DM_DRAWLINE_DST_BYTES 4
#define DM_DRAWLINE_DST_TYPE DMRGBA32
#define DM_DRAWLINE_INIT const DMRGBA32 *c = (DMRGBA32*) &col;
#define DM_DRAWLINE_INNER \
  const DMRGBA32 q = pix[y0 + x0]; \
  const int qr = (q.r + c->r) >> 1, qg = (q.g + c->g) >> 1, qb = (q.b + c->b) >> 1;  \
  pix[y0 + x0].r = qr; \
  pix[y0 + x0].g = qg; \
  pix[y0 + x0].b = qb;
#include "dmdrawline.h"




#define DM_DRAWLINE_NAME dmDrawLine8Saturate
#define DM_DRAWLINE_DST_BYTES 1
#define DM_DRAWLINE_DST_TYPE Uint8
#define DM_DRAWLINE_INNER \
  const int q = pix[y0 + x0] + col; \
  pix[y0 + x0] = q < 255 ? q : 255;
#include "dmdrawline.h"


#define DM_DRAWLINE_NAME dmDrawLine32Saturate
#define DM_DRAWLINE_DST_BYTES 4
#define DM_DRAWLINE_DST_TYPE DMRGBA32
#define DM_DRAWLINE_INIT const DMRGBA32 *c = (DMRGBA32*) &col;
#define DM_DRAWLINE_INNER \
  const DMRGBA32 q = pix[y0 + x0]; \
  const int qr = q.r + c->r, qg = q.g + c->g, qb = q.b + c->b;  \
  pix[y0 + x0].r = qr < 255 ? qr : 255; \
  pix[y0 + x0].g = qg < 255 ? qg : 255; \
  pix[y0 + x0].b = qb < 255 ? qb : 255;
#include "dmdrawline.h"

