#include "dmeval.h"


void dmDoEvalPrintOpTree(FILE *out, DMEvalContext *ev, DMEvalNode *node, int level)
{
    int i;
    while (node != NULL)
    {
        switch (node->op)
        {
            case OP_FUNC:
                fprintf(out, "%s(", node->symbol != NULL ? node->symbol->name : "?ERROR");
                for (i = 0; i < node->symbol->nargs; i++)
                {
                    dmDoEvalPrintOpTree(out, ev, node->args[i], level + 1);
                    if (i < node->symbol->nargs - 1)
                        fprintf(out, ",");
                }
                fprintf(out, ")");
                break;

            case OP_VAR:
                fprintf(out, "%s", node->symbol != NULL ? node->symbol->name : "?ERROR");
                break;

            case OP_VALUE:
                fprintf(out, "%.1f", node->val);
                break;

            case OP_SUBEXPR:
                fprintf(out, "(");
                if (node->subexpr != NULL)
                    dmDoEvalPrintOpTree(out, ev, node->subexpr, level + 1);
                else
                    fprintf(out, "?ERROR");
                fprintf(out, ")");
                break;

            default:
                if (node->op >= 0 && node->op < OP_NOPERS)
                    fprintf(out, "%s", dmEvalOpers[node->op].name);
                else
                    fprintf(out, "ERROR!");
                break;
        }
        node = node->next;
    }
}


void dmEvalPrintOpTree(FILE *out, DMEvalContext *ev, DMEvalNode *node)
{
    dmDoEvalPrintOpTree(out, ev, node, 0);
    fprintf(out, "\n");
}
