/*
 * DMLib
 * -- Simple Bresenham's style line drawing
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2011-2012 Tecnic Software productions (TNSP)
 */

int DM_DRAWLINE_NAME (SDL_Surface *screen, DMFloat fx0, DMFloat fy0, DMFloat fx1, DMFloat fy1, const Uint32 col
#ifdef DM_DRAWLINE_ARGS
    DM_DRAWLINE_ARGS
#endif
)
#ifdef DM_HEADER
;
#else
{
    int dx, dy, xstep, ystep;
    const int qpitch = screen->pitch / DM_DRAWLINE_DST_BYTES;
    (void) qpitch;
    (void) col;

    // Clipping
    if (dmClipLineCoordsFloat(screen, &fx0, &fy0, &fx1, &fy1) < 0)
        return -1;

    int x0 = fx0, y0 = fy0, x1 = fx1, y1 = fy1;

    // Compute initial deltas
    dx = (x1 - x0) * 2;
    dy = (y1 - y0) * 2;


    if (dx < 0)
    {
        dx = -dx;
        xstep = -1;
    }
    else
        xstep = 1;

    if (dy < 0)
    {
        dy = -dy;
        ystep = -1;
    }
    else
        ystep = 1;

#ifndef DM_DRAWLINE_SPEC
    // Compute offsets
    y0 *= qpitch;
    y1 *= qpitch;
    ystep *= qpitch;
#endif

#ifdef DM_DRAWLINE_INIT
    DM_DRAWLINE_INIT
#endif

    DM_DRAWLINE_DST_TYPE *pix = (DM_DRAWLINE_DST_TYPE *) screen->pixels;
    (void) pix;

    // Continue based on which delta is larger
    if (dx > dy)
    {
        int afrac = dy - (dx / 2.0);
        while (x0 != x1)
        {
            if (afrac >= 0)
            {
                y0 += ystep;
                afrac -= dx;
            }

            x0 += xstep;
            afrac += dy;
            
            DM_DRAWLINE_INNER
        }
    }
    else
    {
        int afrac = dx - (dy / 2.0);
        while (y0 != y1)
        {
            if (afrac >= 0)
            {
                x0 += xstep;
                afrac -= dy;
            }

            y0 += ystep;
            afrac += dx;

            DM_DRAWLINE_INNER
        }
    }

    return 0;
}
#endif

#undef DM_DRAWLINE_NAME
#undef DM_DRAWLINE_ARGS
#undef DM_DRAWLINE_DST_BYTES
#undef DM_DRAWLINE_DST_TYPE
#undef DM_DRAWLINE_INIT
#undef DM_DRAWLINE_INNER
