# Additional binaries (aka the demo)
DEMO_BIN=demo
DEMO_OBJS=demo.o dmsimple.o
BINARIES=$(DEMO_BIN)

TOOL_BINPATH=bin/
TESTS_BINPATH=$(TOOL_BINPATH)

# Build engine tests and tools? (Please notice that what
# actually gets built it also affected by other options)
DM_BUILD_TESTS=no
DM_BUILD_TOOLS=no

# Timeline support? (required for editor and complex demos)
DM_USE_TIMELINE=no

# Build Qt based demo editor?
DM_BUILD_EDITOR=no

# Build with runtime asserts?
DM_USE_ASSERTS=yes

# Use plain C routines?
DM_USE_C=yes

# Use MMX/SSE SIMD assembler routines?
DM_USE_SIMD=yes

DM_USE_TREMOR=no

DM_USE_PACKFS=yes
DM_USE_STDIO=yes
DM_USE_MEMIO=no

DM_GFX_BM_TEXT=yes
DM_GFX_TTF_TEXT=no
DM_GFX_LINES=no
DM_GFX_BLITS=yes
DM_GFX_MISC=yes

DM_GFX_8BIT=yes
DM_GFX_32BIT=yes


###
### General build options for miniJSS
###
JSS=yes

# Build a special "light"/minimized version by removing all
# error messages and few other things.
JSS_LIGHT=yes

# Build with extra debugging code? (disabled by JSS_LIGHT=yes)
JSS_DEBUG=no


### Support loading of XM-format module files
JSS_SUP_XM=no


### Generic support of JSSMOD-format modules
JSS_SUP_JSSMOD=yes

# Enable support for different pattern storage modes
# in the JSSMOD _loader_. Saving in xm2jss is not affected.
JSSMOD_FLAGS = -DJM_SUP_PATMODE_ALL

# If SUP_PATMODE_ALL is not defined, then you can enable modes individually
# by uncommenting lines below. Refer to 'xm2jss --help' for mode information.
#JSSMOD_FLAGS += -DJM_SUP_PATMODE_1
#JSSMOD_FLAGS += -DJM_SUP_PATMODE_2
#JSSMOD_FLAGS += -DJM_SUP_PATMODE_3
#JSSMOD_FLAGS += -DJM_SUP_PATMODE_4
#JSSMOD_FLAGS += -DJM_SUP_PATMODE_5

# Enable ext. instrument, instrument header and sampledata loading:
# (if you disable these, you better know what you are doing.)
JSSMOD_FLAGS += -DJM_SUP_EXT_INSTR
JSSMOD_FLAGS += -DJM_SUP_INSTR
JSSMOD_FLAGS += -DJM_SUP_SAMPLES


###
### Locking/thread support
###
JSS_SUP_THREADS=yes


###
### Audio mixing routine support
###
# The actually used functions are determined run-time, so these
# options only enable what is compiled into the library.
JSS_SUP_MIX_C=yes
JSS_SUP_MIX_X86=no
