#!/bin/sh
. ./build.cfg
CPWD=`pwd`

for build in intel:core2; do
	# Split into platform and march
	platform=`echo "$build"|cut -d ':' -f 1`
	march=`echo "$build"|cut -d ':' -f 2`
	
	# Build Unix binary
	make -f Makefile clean
	make -f Makefile EXTRA_CFLAGS="-O3 -march=$march" EXEEXT=".bin" BINPATH="$CPWD/"
	(strip "$CPWD/${CEXE}.bin" && mv "$CPWD/${CEXE}.bin" "$CPWD/${CBINPATH}/${CEXE}-linux-x86.bin") || exit 1

	# Build Win32 executable
	make -f Makefile.w32 clean
	make -f Makefile.w32 EXTRA_CFLAGS="-O3 -march=$march" EXEEXT=".exe" BINPATH="$CPWD/"
	(mv "$CPWD/${CEXE}.exe" "$CPWD/${CBINPATH}/${CEXE}-win32.exe") || exit 1
done

(cd "$CPWD" && exec ./build-data.sh) || exit 1

rm -f "$CPWD/$CZIP"

cd "$CPWD/${CBINPATH}/" && zip -9 "$CPWD/$CZIP" *
