/*
 * Decompiled with CFR 0.152.
 */
package saito.objloader;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.media.opengl.GL;
import processing.core.PApplet;
import processing.core.PVector;
import saito.objloader.Debug;
import saito.objloader.Face;

public class Segment {
    public ArrayList<Face> faces = new ArrayList();
    public String materialName;
    public IntBuffer indexIB;
    public FloatBuffer dataFB;
    int[] glbuf;

    public String getMaterialName() {
        return this.materialName;
    }

    public Face getFace(int index) {
        return this.faces.get(index);
    }

    public Face[] getFaces() {
        return this.faces.toArray(new Face[this.faces.size()]);
    }

    public PVector[] getIndices() {
        ArrayList indices = new ArrayList();
        int i = 0;
        while (i < this.faces.size()) {
            indices.addAll(Arrays.asList(this.getFace(i).getVertices()));
            ++i;
        }
        return indices.toArray(new PVector[indices.size()]);
    }

    public int getFaceCount() {
        return this.faces.size();
    }

    public int getIndexCount() {
        int count = 0;
        int i = 0;
        while (i < this.getFaceCount()) {
            count += this.getFace(i).getVertIndexCount();
            ++i;
        }
        return count;
    }

    public void sortFacesByX() {
        Collections.sort(this.faces, Face.FaceXComparator);
    }

    public void sortFacesByY() {
        Collections.sort(this.faces, Face.FaceYComparator);
    }

    public void sortFacesByZ() {
        Collections.sort(this.faces, Face.FaceZComparator);
    }

    public void setupGL(GL gl, Debug debug, PVector[] p, PVector[] t, PVector[] n) {
        int[] vertind = new int[]{};
        int[] texind = new int[]{};
        int[] normind = new int[]{};
        int j = 0;
        while (j < this.getFaceCount()) {
            Face tmpf = this.getFace(j);
            if (j == 0) {
                vertind = tmpf.getVertexIndices();
                texind = tmpf.getTextureIndices();
                normind = tmpf.getNormalIndices();
            } else {
                vertind = PApplet.concat((int[])vertind, (int[])tmpf.getVertexIndices());
                texind = PApplet.concat((int[])texind, (int[])tmpf.getTextureIndices());
                normind = PApplet.concat((int[])normind, (int[])tmpf.getNormalIndices());
            }
            ++j;
        }
        int stride = 8;
        float[] f = new float[vertind.length * stride];
        debug.println("there are this many floats = " + f.length);
        int i = 0;
        while (i < f.length / stride) {
            PVector points = p[vertind[i]];
            PVector textureUV = t[texind[i]];
            PVector normals = n[normind[i]];
            f[i * stride] = points.x;
            f[i * stride + 1] = points.y;
            f[i * stride + 2] = points.z;
            f[i * stride + 3] = textureUV.x;
            f[i * stride + 4] = 1.0f - textureUV.y;
            f[i * stride + 5] = normals.x;
            f[i * stride + 6] = normals.y;
            f[i * stride + 7] = normals.z;
            ++i;
        }
        this.glbuf = new int[2];
        gl.glGenBuffers(1, this.glbuf, 0);
        this.dataFB = this.setupFloatBuffer(f);
        this.bindThisBuffer(gl, this.glbuf[0], f, this.dataFB);
        int[] index = new int[f.length / 8];
        int i2 = 0;
        while (i2 < index.length) {
            index[i2] = i2;
            ++i2;
        }
        this.indexIB = this.setupIntBuffer(index);
    }

    public void beginDrawGL(GL gl) {
        gl.glBindBuffer(34962, this.glbuf[0]);
        gl.glEnableClientState(32884);
        gl.glEnableClientState(32888);
        gl.glEnableClientState(32885);
        gl.glVertexPointer(3, 5126, 32, 0L);
        gl.glTexCoordPointer(2, 5126, 32, 12L);
        gl.glNormalPointer(5126, 32, 20L);
        gl.glFrontFace(2305);
        gl.glPolygonMode(1028, 6914);
    }

    public void drawGL(GL gl, int GLTYPE) {
        this.beginDrawGL(gl);
        gl.glDrawArrays(GLTYPE, 0, this.indexIB.capacity());
        this.endDrawGL(gl);
    }

    public void endDrawGL(GL gl) {
        gl.glDisableClientState(32888);
        gl.glDisableClientState(32885);
        gl.glDisableClientState(32884);
    }

    private IntBuffer setupIntBuffer(int[] i) {
        IntBuffer fb = ByteBuffer.allocateDirect(4 * i.length).order(ByteOrder.nativeOrder()).asIntBuffer();
        fb.put(i);
        fb.rewind();
        return fb;
    }

    private FloatBuffer setupFloatBuffer(float[] f) {
        FloatBuffer fb = ByteBuffer.allocateDirect(4 * f.length).order(ByteOrder.nativeOrder()).asFloatBuffer();
        fb.put(f);
        fb.rewind();
        return fb;
    }

    private void bindThisBuffer(GL gl, int num, float[] f, FloatBuffer FB) {
        gl.glBindBuffer(34962, num);
        gl.glBufferData(34962, 4 * f.length, (Buffer)FB, 35044);
    }
}

