/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.midi;

import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import org.tritonus.share.midi.TMidiDevice;

public abstract class TDirectSynthesizer
extends TMidiDevice
implements Synthesizer {
    private int[] m_anBanks = new int[16];

    public TDirectSynthesizer(MidiDevice.Info info) {
        super(info, false, true);
        for (int i = 0; i < this.m_anBanks.length; ++i) {
            this.m_anBanks[i] = -1;
        }
    }

    protected void openImpl() throws MidiUnavailableException {
    }

    protected void closeImpl() {
    }

    protected void receive(MidiMessage message, long lTimeStamp) {
        if (message instanceof ShortMessage) {
            ShortMessage shortMsg = (ShortMessage)message;
            int nChannel = shortMsg.getChannel();
            int nCommand = shortMsg.getCommand();
            int nData1 = shortMsg.getData1();
            int nData2 = shortMsg.getData2();
            block0 : switch (nCommand) {
                case 128: {
                    this.getChannel(nChannel).noteOff(nData1, nData2);
                    break;
                }
                case 144: {
                    this.getChannel(nChannel).noteOn(nData1, nData2);
                    break;
                }
                case 160: {
                    this.getChannel(nChannel).setPolyPressure(nData1, nData2);
                    break;
                }
                case 176: {
                    switch (nData1) {
                        case 0: {
                            this.m_anBanks[nChannel] = nData2 << 7;
                            break block0;
                        }
                        case 32: {
                            int n = nChannel;
                            this.m_anBanks[n] = this.m_anBanks[n] | nData2;
                            break block0;
                        }
                        case 120: {
                            this.getChannel(nChannel).allSoundOff();
                            break block0;
                        }
                        case 121: {
                            this.getChannel(nChannel).resetAllControllers();
                            break block0;
                        }
                        case 122: {
                            this.getChannel(nChannel).localControl(nData2 == 127);
                            break block0;
                        }
                        case 123: {
                            this.getChannel(nChannel).allNotesOff();
                            break block0;
                        }
                        case 124: {
                            this.getChannel(nChannel).setOmni(false);
                            break block0;
                        }
                        case 125: {
                            this.getChannel(nChannel).setOmni(true);
                            break block0;
                        }
                        case 126: {
                            this.getChannel(nChannel).setMono(true);
                            break block0;
                        }
                        case 127: {
                            this.getChannel(nChannel).setMono(false);
                            break block0;
                        }
                    }
                    this.getChannel(nChannel).controlChange(nData1, nData2);
                    break;
                }
                case 192: {
                    if (this.m_anBanks[nChannel] != -1) {
                        this.getChannel(nChannel).programChange(this.m_anBanks[nChannel], nData1);
                        this.m_anBanks[nChannel] = -1;
                        break;
                    }
                    this.getChannel(nChannel).programChange(nData1);
                    break;
                }
                case 208: {
                    this.getChannel(nChannel).setChannelPressure(nData1);
                    break;
                }
                case 224: {
                    this.getChannel(nChannel).setPitchBend(nData1 | nData2 << 7);
                    break;
                }
            }
        }
    }

    private MidiChannel getChannel(int nChannel) {
        return this.getChannels()[nChannel];
    }
}

