; ------------------------------------------------------------------------------
; author: klarre, 2013
; king internal demo competition #2
; $ sudo apt-get install build-essential qemu nasm
; $ ./build_and_run_qemu.sh
; ------------------------------------------------------------------------------
bits 16

section .data	align=16

quads_size	equ	2
quads		resb 16 * quads_size

section .text

start:
	mov		ax, 0x07c0
	add		ax, 288
	mov		ss, ax
	mov		sp, 4096
	mov		ax, 0x7c0
	mov		ds, ax
	mov		ax, 0x13
	int		0x10
	call	main_loop
	jmp		$

main_loop:
	call	initialize
	push	0fh
	call	clear_screen
	add		sp, 2

.main_loop_start:
	call	delay
	call	update
	call	draw
	jmp		.main_loop_start

initialize:
	pusha
	mov		bx, quads
	xor		cx, cx
	mov		ax, 1
.loop:
	mov		[bx], word 1
	mov		[bx+2], word 8
	mov		[bx+4], word 8
	mov		[bx+6], word 4
	mov		[bx+8], word ax
	inc		ax
	mov		[bx+10], word 1
	mov		[bx+12], word 0x55
	add		bx, 16
	inc		cx
	cmp		cx, quads_size
	jl		.loop
	popa
	ret

update:
	call	update_quads
	call	update_wall_collisions
	ret

draw:
	pusha
	mov		bx, quads
	xor		cx, cx
.loop:
	push	word [bx]
	push	word [bx+2]
	push	word [bx+4]
	push	word [bx+6]
	push	word [bx+12]
	call	draw_rectangle
	add		sp, 10

	add		bx, 16
	inc		cx
	cmp		cx, quads_size
	jl		.loop

	push	320
	push	16
	push	0
	push	184
	push	0
	call	draw_rectangle
	add		sp, 10

	push	320
	push	16
	push	0
	push	0
	push	0
	call	draw_rectangle
	add		sp, 10

	popa
	ret

update_quads:
	pusha
	mov		bx, quads
	xor		cx, cx
.loop:
	mov		ax, word [bx+8]
	add		[bx+4], ax
	mov		ax, word [bx+10]
	add		[bx+6], ax
	add		bx, 16
	inc		cx
	cmp		cx, quads_size
	jl		.loop
	popa
	ret

update_wall_collisions:
	pusha
	mov		bx, quads
	xor		cx, cx
.loop:
	cmp		[bx+4], word 0	; Check outside left
	jl		.outside_lx

	mov		ax, [bx+4]		; Check outside right
	add		ax, [bx+0]
	cmp		ax, 320
	jg		.outside_x

	cmp		[bx+6], word 0	; Check outside top
	jl		.outside_ly

	mov		ax, [bx+6]		; Check outside bottom
	add		ax, [bx+2]
	cmp		ax, 200
	jg		.outside_y

	jmp	.done

.outside_lx:
	mov		ax, [bx+4]
	imul	ax, word 2
	neg		ax
	mov		[bx+4], ax
	neg		word [bx+8]
	mov		dx, [8h]
	add		dx, [fs:046ch]
	mov		word [bx+12], dx
	jmp		.done
.outside_x:
	sub		ax, 320
	neg		ax
	add		ax, 320
	sub		ax, [bx+0]
	mov		[bx+4], ax
	neg		word [bx+8]
	mov		dx, [24h]
	add		dx, [fs:046ch]
	mov		word [bx+12], dx
	jmp		.done
.outside_ly:
	mov		ax, [bx+6]
	imul	ax, word 2
	neg		ax
	mov		[bx+6], ax
	neg		word [bx+10]
	mov		dx, [44h]
	add		dx, [fs:046ch]
	mov		word [bx+12], dx
	jmp		.done
.outside_y:
	sub		ax, 200
	neg		ax
	add		ax, 200
	sub		ax, [bx+2]
	mov		[bx+6], ax
	neg		word [bx+10]
	mov		dx, [32h]
	add		dx, [fs:046ch]
	mov		word [bx+12], dx

.done:
	add		bx, 16
	inc		cx
	cmp		cx, quads_size
	jl		.loop
	popa
	ret

delay:
	pusha
	mov		ah, 86h
	mov		cx, 0h
	mov		dx, 01h
	int		15h
	popa
	ret

; ------------------------------------------------------------------------------
; sp+2	color
; sp+4	position y
; sp+6	position x
; ------------------------------------------------------------------------------
put_pixel:
	pusha
	mov		bp, sp
	add		bp, 16
	mov		ax, 0a000h
	mov		es, ax
	mov		bx, [bp+4]
	imul	bx, 320
	add		bx, [bp+6]
	mov		di, bx
	mov		dl, [bp+2]
	mov		[es:di], dl
	popa
	ret

; ------------------------------------------------------------------------------
; sp+2	color
; ------------------------------------------------------------------------------
clear_screen:
	pusha
	mov		bp, sp
	add		bp, 16
	mov		ax, 0a000h
	mov		es, ax
	xor		di, di
	mov		al, [bp+2]
	mov		cx, 64000
	cld
	rep		stosb
	popa
	ret

; ------------------------------------------------------------------------------
; sp+2	color
; sp+4	position y
; sp+6	position x
; sp+8	height
; sp+10	width
; ------------------------------------------------------------------------------
draw_rectangle:
	pusha
	mov		bp, sp
	add		bp, 16
	xor		cx, cx		; Reset row counter
	mov		bx, [bp+4]	; Store y position in bx
.repeat_y:
	mov		ax, [bp+6]	; Store x position in ax
	inc		cx			; Increase row counter
.repeat_x:
	pusha
	push	ax			; Push x value
	push	bx			; Push y value
	mov		dl, [bp+2]
	push	dx			; Push color
	call	put_pixel
	pop		dx
	pop		bx
	pop		ax
	popa

	inc		ax			; Increase x
	push	bx
	mov		bx, [bp+10]
	add		bx, [bp+6]
	cmp		ax, bx		; Check if row is complete
	pop		bx
	jne		.repeat_x

	add		bx, 1		; Increase y
	cmp		cx, [bp+8]	; Check if rectangle is complete
	jne		.repeat_y
	popa
	ret

	times	510-($-$$) db 0	; Pad boot sector
	dw		0xaa55
