/*
 * Decompiled with CFR 0.152.
 */
package hm;

import hm.Robot;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.GunTurnCompleteCondition;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TurnCompleteCondition;
import robocode.util.Utils;

public class Pomeroni
extends AdvancedRobot {
    int follow;
    String name_follow;
    double MIN_FOLLOW_DISTANCE = 1000.0;
    double MAX_FIRE_DISTANCE = 700.0;
    double MIN_FOLLOW_TIME = 4.0;
    double MIN_DISTANCE = 200.0;
    double MAX_DISTANCE_AVOID_BULLET = 500.0;
    double last_follow = 0.0;
    int wallMargin = 40;
    int direction = 1;
    int duel = 0;
    Vector robots;
    double FOLLOW_BLOCK_TIME = 20.0;
    double WALLHIT_CHECK_DISTANCE = 40.0;
    double WAY_TOO_CLOSE_DISTANCE = 20.0;

    public void run() {
        this.out.println("Hello, INSTANSSI 2013!\nThis is Pomeroni v2.0-build1217\n............................................\nCredits: #instanssi #isobaari JYFL Logio Gagis Sahra");
        this.robots = new Vector();
        this.follow = 0;
        this.name_follow = "";
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        while (true) {
            this.setTurnRadarLeft(50000.0);
            this.CheckBadMovement();
            this.waitFor((Condition)new TurnCompleteCondition((AdvancedRobot)this));
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        boolean found = false;
        double absolute_angle = this.getHeadingRadians() + e.getBearingRadians();
        Robot enemy = new Robot();
        if (this.robots.size() == 1) {
            this.duel = 1;
        }
        int i = 0;
        while (i < this.robots.size()) {
            if (e.getName() == ((Robot)this.robots.elementAt(i)).GetName()) {
                double delta_hp;
                found = true;
                ((Robot)this.robots.elementAt(i)).SetTime(e.getTime());
                ((Robot)this.robots.elementAt(i)).SetX(this.getX() + e.getDistance() * Math.sin(absolute_angle));
                ((Robot)this.robots.elementAt(i)).SetY(this.getY() - e.getDistance() * Math.cos(absolute_angle));
                enemy = (Robot)this.robots.elementAt(i);
                if (enemy.FollowBlocked() > 0.0 && (double)this.getTime() - enemy.FollowBlocked() > 20.0) {
                    enemy.RemoveFollowBlocked();
                    this.out.println("Removing follow block for " + enemy.GetName());
                }
                if ((delta_hp = ((Robot)this.robots.elementAt(i)).GetHP() - e.getEnergy()) > 0.0 && delta_hp <= 3.0 && (this.duel == 1 || e.getDistance() < this.MAX_DISTANCE_AVOID_BULLET)) {
                    this.PanicAvoidBullet((Robot)this.robots.elementAt(i));
                }
                ((Robot)this.robots.elementAt(i)).SetHP(e.getEnergy());
            }
            ++i;
        }
        if (!found) {
            Robot nrobo = new Robot();
            nrobo.SetName(e.getName());
            nrobo.SetTime(e.getTime());
            nrobo.SetX(this.getX() + e.getDistance() * Math.sin(absolute_angle));
            nrobo.SetY(this.getY() + e.getDistance() * Math.cos(absolute_angle));
            this.out.println("New robot " + e.getName() + " at " + nrobo.GetX() + " , " + nrobo.GetY() + " own position " + this.getX() + ", " + this.getY());
            this.robots.addElement(nrobo);
            enemy = nrobo;
            if (this.robots.size() > 1) {
                this.duel = 0;
            }
        }
        if (this.duel == 0) {
            boolean closest = true;
            for (ScannedRobotEvent event : this.getScannedRobotEvents()) {
                if (!(e.getDistance() > event.getDistance() * 1.01)) continue;
                closest = false;
            }
            if (!closest) {
                return;
            }
            if (enemy.FollowBlocked() > 0.0) {
                return;
            }
            if (e.getDistance() > this.MIN_FOLLOW_DISTANCE) {
                return;
            }
            if ((double)this.getTime() - this.last_follow < this.MIN_FOLLOW_TIME && e.getName() != this.name_follow && e.getDistance() > this.WAY_TOO_CLOSE_DISTANCE) {
                return;
            }
        }
        double v = Math.abs(e.getVelocity());
        double v_x = v * Math.cos(absolute_angle);
        double v_y = v * Math.sin(absolute_angle);
        double dist_x = e.getDistance() * Math.sin(absolute_angle);
        double dist_y = e.getDistance() * Math.cos(absolute_angle);
        double power = 1.0;
        if (e.getDistance() < 200.0) {
            power = 3.0;
        } else if (e.getDistance() < 350.0) {
            power = 2.5;
        } else if (e.getDistance() < 500.0) {
            power = 2.0;
        }
        double enemy_absolute_bearing = e.getBearingRadians() + this.getHeadingRadians();
        double enemy_perp_vel = e.getVelocity() * Math.sin(e.getHeadingRadians() - enemy_absolute_bearing);
        double ammo_vel = 20.0 - 3.0 * power;
        double time = e.getDistance() / ammo_vel;
        double turn = enemy_absolute_bearing - this.getHeadingRadians() + Math.asin(enemy_perp_vel / ammo_vel);
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        turn = Utils.normalRelativeAngle((double)turn);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians() + e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing) / ammo_vel)));
        double mindist = this.MIN_DISTANCE;
        if (this.duel == 1) {
            mindist *= 1.2;
        }
        if (e.getDistance() < mindist) {
            this.out.println("Tooclose, dist " + e.getDistance());
            this.setAhead(e.getDistance() - mindist);
            this.setTurnRight(20.0 * Math.sin(this.getTime()));
            if (Math.abs(this.getGunTurnRemaining()) < 10.0) {
                this.out.println("Close-range shoot!");
                this.setFire(2.5);
            }
        } else {
            this.setTurnRight(this.RadToDeg(turn) + 20.0 * Math.sin((double)this.getTime() / 1.0));
            double move = e.getDistance() - this.MIN_DISTANCE;
            if (move < 0.0) {
                this.out.println("WTF, negative movement????");
            }
            this.setAhead((double)this.direction * move);
        }
        this.waitFor((Condition)new GunTurnCompleteCondition((AdvancedRobot)this));
        if (e.getDistance() < this.MAX_FIRE_DISTANCE) {
            this.setFire(power);
        }
        this.last_follow = this.getTime();
        this.name_follow = e.getName();
    }

    public void CheckBadMovement() {
        double x = this.getX();
        double y = this.getY();
        if (x < this.WALLHIT_CHECK_DISTANCE || y < this.WALLHIT_CHECK_DISTANCE || this.getBattleFieldWidth() - x < this.WALLHIT_CHECK_DISTANCE || this.getBattleFieldHeight() - y < this.WALLHIT_CHECK_DISTANCE) {
            double angle = this.getHeadingRadians();
            double dist = this.getDistanceRemaining();
            double dx = dist * Math.sin(angle);
            double dy = dist * Math.cos(angle);
            double newx = this.getX() + dx;
            double newy = this.getY() + dy;
            if (newx < this.WALLHIT_CHECK_DISTANCE / 1.0 || newy < this.WALLHIT_CHECK_DISTANCE / 1.0 || this.getBattleFieldWidth() - newx < this.WALLHIT_CHECK_DISTANCE / 1.0 || this.getBattleFieldHeight() - newy < this.WALLHIT_CHECK_DISTANCE / 1.0) {
                this.out.println("Collision........");
                this.setTurnLeft(30.0);
                this.setAhead(-40.0);
            }
        }
    }

    public void PanicAvoidBullet(Robot robo) {
        if (this.duel == 1) {
            this.out.println("Avoid robo " + robo.GetName());
            this.setTurnRight(30.0);
            this.setAhead(20.0);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
        this.out.println("Wallhit (why????)");
        this.setBack(30.0);
        this.setTurnLeft(90.0);
    }

    public double DegToRad(double deg) {
        return deg / 360.0 * 2.0 * 3.1415192;
    }

    public double RadToDeg(double rad) {
        return rad / 6.2831853 * 360.0;
    }

    public void onHitRobot(HitRobotEvent e) {
        double enemy_absolute_bearing = e.getBearingRadians() + this.getHeadingRadians();
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        this.out.println("Skipped turn :o");
    }

    public void onRobotDeath(RobotDeathEvent e) {
        int i = 0;
        while (i < this.robots.size()) {
            if (e.getName() == ((Robot)this.robots.elementAt(i)).GetName()) {
                this.robots.remove(i);
                this.out.println("Robot " + e.getName() + " died");
            }
            ++i;
        }
        if (this.robots.size() == 1) {
            this.duel = 1;
        }
    }

    public void onCustomEvent(CustomEvent e) {
    }
}

