var Kaleido = (function () {

    "use strict";

    var _model,
        _duration = 0,
        _sync,
        _width,
        _height,
        _ctx,
        _logoCtx,
        _preflightCallback;

    var _kaleidoskop,
        _kctx,
        _kParts,
        _kStartAngle,
        _kMulti,
        _blackFade,
        _glow,
        _slice,
        _logoAlpha,
        _logoStab,
        _logoAngle,
        _logoStripes,
        _logoMaxAmp;

    var _imgW,
        _imgH;

    function preflight(callbackFn, duration, model) {
        _preflightCallback = callbackFn;

        _duration = duration;
        _model = model;

        _sync = _model.sync;
        _width = _model.width();
        _height = _model.height();

        initSync();

        _ctx = _model.twoDeeRenderer;

        var c = document.createElement('canvas');
        c.width = _width;
        c.height = _height;
        _kctx = c.getContext('2d');

        _kaleidoskop = new Kaleidoscope();
        _kaleidoskop.setContext(_kctx);

        c = document.createElement('canvas');
        c.width = _width;
        c.height = _height;
        _logoCtx = c.getContext('2d');

        _preflightCallback();
    }

    function init() {
        _model.on("resize", resize);

        _imgW = Meat.apophenia.width / 1920 * _width;
        _imgH = Meat.apophenia.height / 1080 * _height;

        _slice = new Slice();
        _slice.setContext(_logoCtx);

        if (_ctx.setLineDash)
            _ctx.setLineDash([0]);
        else{
            try {
                _ctx.mozDash = [1];
            } catch(error) {}
        }
    }

    function initSync() {
        //_blackFade = _sync.getTrack('blackFade');
        _kParts = _sync.getTrack('k:Parts');
        _kStartAngle = _sync.getTrack('k:StartAngle');
        _kMulti = _sync.getTrack('k:xyMulti');
        _blackFade = _sync.getTrack('blackFade');
        _glow = _sync.getTrack('glow');

        _logoAlpha = _sync.getTrack('logoAlpha');
        _logoStab = _sync.getTrack('logoStab');
        _logoAngle = _sync.getTrack('logoAngle');
        _logoStripes = _sync.getTrack('logoStripes');
        _logoMaxAmp = _sync.getTrack('logoMaxAmp');
    }

    function render(sceneTime, floatBeat, frameDelta, row) {

        _kctx.clearRect(0,0,_width,_height);

        _kaleidoskop.setAngle(_kStartAngle.getValue(row));
        _kaleidoskop.setParts(_kParts.getValue(row));
        var multi = 100 / 1920 * _kMulti.getValue(row),
            offX = Math.cos(row / 20) * multi,
            offY = Math.sin(row / 10) * multi;

        _kctx.drawImage(Meat.kaleidoskop, offX, offY,
            1920 / Meat.kaleidoskop.width * _width, 1080 / Meat.kaleidoskop.height * _height);

        _ctx.drawImage(Meat.kbg, 0,0,Meat.kbg.width / 1920 * _width, Meat.kbg.height / 1080 * _height);
        //_ctx.fillStyle  = '#312D34';
        //_ctx.fillRect(0,0,_width,_height);

        _kaleidoskop.render();

        _ctx.drawImage(_kctx.canvas, 0,0);

        //_ctx.drawImage(Meat.apophenia, (_width - _imgW) / 2,(_height - _imgH) / 2,_imgW, _imgH);

        var logoAlpha = _logoAlpha.getValue(row);

        if(logoAlpha > 0){
            _logoCtx.clearRect(0, 0, _width, _height);
            _logoCtx.save();
            _logoCtx.globalAlpha = logoAlpha;
            _logoCtx.drawImage(Meat.apophenia, (_width - _imgW) / 2,(_height - _imgH) / 2,_imgW, _imgH);
            _logoCtx.restore();

            _slice.setAngle(_logoAngle.getValue(row));
            _slice.setStripes(_logoStripes.getValue(row));
            _slice.setMaxAmplitude(_logoMaxAmp.getValue(row));
            _slice.setAmplitudeMultiplicator(_logoStab.getValue(row));

            _slice.render(row);

            _ctx.drawImage(_logoCtx.canvas, 0, 0);
        }

        var glow = _glow.getValue(row),
            bF = _blackFade.getValue(row);

        if (glow > 0) {
            var glowScale = 1;

            for(var i = 0; i < 4; i++ ){
                glowScale += .01;
                var sW = _width * glowScale,
                    sH = _height * glowScale;
                _ctx.save();
                _ctx.globalCompositeOperation = 'lighter';
                _ctx.globalAlpha = glow;
                _ctx.drawImage(_ctx.canvas, (_width - sW) / 2, (_height - sH) / 2, sW, sH);
                _ctx.restore();
            }
        }
        
        if (bF > 0) {
            _ctx.fillStyle = "rgba(0,0,0," + bF + ")";
            _ctx.fillRect(0, 0, _width, _height);
        }
    }

    function onBeat(integerBeat, msTime, majorBeat, minorBeat) {
    }

    function clear() {
        _model.on("resize", function () {
        });
    }

    function resize(width, height) {
        _width = width;
        _height = height;
    }

    return {
        preflight: preflight,
        init: init,
        render: render,
        onBeat: onBeat,
        clear: clear,
        resize: resize
    };
}());