/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.Minim;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.UGen;
import java.util.Arrays;

public class Sampler
extends UGen {
    public UGen.UGenInput begin;
    public UGen.UGenInput end;
    public UGen.UGenInput attack;
    public UGen.UGenInput amplitude;
    public UGen.UGenInput rate;
    public boolean looping;
    private MultiChannelBuffer sampleData;
    private float sampleDataSampleRate;
    private float basePlaybackRate;
    private Trigger[] triggers;
    private int nextTrigger;

    public Sampler(String string, int n, Minim minim) {
        this.triggers = new Trigger[n];
        for (int i = 0; i < n; ++i) {
            this.triggers[i] = new Trigger();
        }
        this.sampleData = new MultiChannelBuffer(1, 1);
        this.sampleDataSampleRate = minim.loadFileIntoBuffer(string, this.sampleData);
        this.createInputs();
    }

    public Sampler(MultiChannelBuffer multiChannelBuffer, float f, int n) {
        this.triggers = new Trigger[n];
        for (int i = 0; i < n; ++i) {
            this.triggers[i] = new Trigger();
        }
        this.sampleData = new MultiChannelBuffer(multiChannelBuffer.getChannelCount(), multiChannelBuffer.getBufferSize());
        this.sampleData.set(multiChannelBuffer);
        this.sampleDataSampleRate = f;
        this.createInputs();
    }

    private void createInputs() {
        this.begin = this.addControl(0.0f);
        this.end = this.addControl(this.sampleData.getBufferSize() - 1);
        this.attack = this.addControl();
        this.amplitude = this.addControl(1.0f);
        this.rate = this.addControl(1.0f);
    }

    public void trigger() {
        this.triggers[this.nextTrigger].activate();
        this.nextTrigger = (this.nextTrigger + 1) % this.triggers.length;
    }

    public void stop() {
        for (Trigger trigger : this.triggers) {
            trigger.stop();
        }
    }

    public void setSample(MultiChannelBuffer multiChannelBuffer, float f) {
        this.sampleData.set(multiChannelBuffer);
        this.sampleDataSampleRate = f;
        this.basePlaybackRate = f / this.sampleRate();
    }

    @Override
    protected void sampleRateChanged() {
        this.basePlaybackRate = this.sampleDataSampleRate / this.sampleRate();
    }

    @Override
    protected void uGenerate(float[] fArray) {
        Arrays.fill(fArray, 0.0f);
        for (Trigger trigger : this.triggers) {
            trigger.generate(fArray);
        }
    }

    private class Trigger {
        float beginSample;
        float endSample;
        float playbackRate;
        float sample;
        float outSampleCount;
        int attackLength;
        float attackAmp;
        float attackAmpStep;
        int release;
        boolean done = true;

        Trigger() {
        }

        void activate() {
            this.beginSample = Sampler.this.begin.getLastValue();
            this.endSample = Sampler.this.end.getLastValue();
            this.playbackRate = Sampler.this.rate.getLastValue();
            this.attackLength = (int)Math.max(Sampler.this.sampleRate() * Sampler.this.attack.getLastValue(), 1.0f);
            this.attackAmp = 0.0f;
            this.attackAmpStep = 1.0f / (float)this.attackLength;
            this.release = 0;
            this.sample = this.beginSample;
            this.outSampleCount = 0.0f;
            this.done = false;
        }

        void stop() {
            this.done = true;
        }

        void generate(float[] fArray) {
            if (this.done) {
                return;
            }
            float f = Sampler.this.amplitude.getLastValue() * this.attackAmp;
            int n = 0;
            while (n < fArray.length) {
                int n2 = n < Sampler.this.sampleData.getChannelCount() ? n : Sampler.this.sampleData.getChannelCount() - 1;
                int n3 = n++;
                fArray[n3] = fArray[n3] + f * Sampler.this.sampleData.getSample(n2, this.sample);
            }
            this.sample += this.playbackRate * Sampler.this.basePlaybackRate;
            if (this.sample > this.endSample) {
                if (Sampler.this.looping) {
                    this.sample -= this.endSample - this.beginSample;
                } else {
                    this.done = true;
                }
            }
            this.outSampleCount += 1.0f;
            if (this.outSampleCount <= (float)this.attackLength) {
                this.attackAmp += this.attackAmpStep;
            }
        }
    }
}

