/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.AudioOutput;
import ddf.minim.Minim;
import ddf.minim.UGen;

public class Damp
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    private float maxAmp;
    private float amp;
    private float dampTime;
    private float attackTime;
    private float beforeAmplitude;
    private float afterAmplitude;
    private float timeStepSize;
    private float now;
    private boolean isActivated;
    private boolean unpatchAfterDamp;
    private AudioOutput output;
    private UGen ugenOutput;

    public Damp() {
        this(0.0f, 1.0f, 1.0f, 0.0f, 0.0f);
    }

    public Damp(float f) {
        this(0.0f, f, 1.0f, 0.0f, 0.0f);
    }

    public Damp(float f, float f2) {
        this(f, f2, 1.0f, 0.0f, 0.0f);
    }

    public Damp(float f, float f2, float f3) {
        this(f, f2, f3, 0.0f, 0.0f);
    }

    public Damp(float f, float f2, float f3, float f4, float f5) {
        this.attackTime = f;
        this.dampTime = f2;
        this.maxAmp = f3;
        this.beforeAmplitude = f4;
        this.afterAmplitude = f5;
        this.isActivated = false;
        this.amp = this.beforeAmplitude;
        Minim.debug(" attackTime = " + f + " dampTime = " + f2 + " maxAmp = " + this.maxAmp + " now = " + this.now);
    }

    public void activate() {
        this.now = 0.0f;
        this.isActivated = true;
        this.amp = this.timeStepSize > this.attackTime ? this.maxAmp : 0.0f;
    }

    public void setAttackTime(float f) {
        this.attackTime = f;
    }

    public void setDampTime(float f) {
        this.dampTime = f;
    }

    public void setDampTimeFromDuration(float f) {
        float f2 = f - this.attackTime;
        if (f2 > 0.0f) {
            this.dampTime = f2;
        } else {
            this.attackTime = f / 2.0f;
            this.dampTime = f / 2.0f;
        }
    }

    @Override
    protected void sampleRateChanged() {
        this.timeStepSize = 1.0f / this.sampleRate();
    }

    public void unpatchAfterDamp(AudioOutput audioOutput) {
        this.unpatchAfterDamp = true;
        this.output = audioOutput;
    }

    public void unpatchAfterDamp(UGen uGen) {
        this.unpatchAfterDamp = true;
        this.ugenOutput = uGen;
    }

    @Override
    protected void uGenerate(float[] fArray) {
        if (!this.isActivated) {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = this.beforeAmplitude * this.audio.getLastValues()[i];
            }
        } else if (this.now >= this.dampTime + this.attackTime) {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = this.afterAmplitude * this.audio.getLastValues()[i];
            }
            if (this.unpatchAfterDamp) {
                if (this.output != null) {
                    this.unpatch(this.output);
                    this.output = null;
                } else if (this.ugenOutput != null) {
                    this.unpatch(this.ugenOutput);
                    this.ugenOutput = null;
                }
                this.unpatchAfterDamp = false;
                Minim.debug(" unpatching Damp ");
            }
        } else if (this.now >= this.attackTime) {
            this.amp += (this.afterAmplitude - this.amp) * this.timeStepSize / (this.dampTime + this.attackTime - this.now);
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = this.amp * this.audio.getLastValues()[i];
            }
            this.now += this.timeStepSize;
        } else {
            this.amp += (this.maxAmp - this.amp) * this.timeStepSize / (this.attackTime - this.now);
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = this.amp * this.audio.getLastValues()[i];
            }
            this.now += this.timeStepSize;
        }
    }
}

