/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.ugens.Instrument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class NoteManager {
    private float sampleRate;
    private float tempo;
    private float noteOffset;
    private float durationFactor;
    private int now;
    private HashMap<Integer, ArrayList<NoteEvent>> events;
    private boolean paused;

    public NoteManager(float f) {
        this.sampleRate = f;
        this.events = new HashMap();
        this.tempo = 60.0f;
        this.noteOffset = 0.0f;
        this.durationFactor = 1.0f;
        this.now = 0;
        this.paused = false;
    }

    public synchronized void addEvent(float f, float f2, Instrument instrument) {
        Serializable serializable;
        int n = this.now + (int)(this.sampleRate * (f + this.noteOffset) * 60.0f / this.tempo);
        Integer n2 = new Integer(n);
        float f3 = f2 * this.durationFactor * 60.0f / this.tempo;
        if (this.events.containsKey(n2)) {
            serializable = this.events.get(n2);
            serializable.add(new NoteOnEvent(instrument, f3));
        } else {
            serializable = new ArrayList<NoteOnEvent>();
            serializable.add(new NoteOnEvent(instrument, f3));
            this.events.put(n2, (ArrayList<NoteEvent>)serializable);
        }
        serializable = new Integer(n + (int)(this.sampleRate * f3));
        if (this.events.containsKey(serializable)) {
            ArrayList<NoteEvent> arrayList = this.events.get(serializable);
            arrayList.add(new NoteOffEvent(instrument));
        } else {
            ArrayList<NoteOffEvent> arrayList = new ArrayList<NoteOffEvent>();
            arrayList.add(new NoteOffEvent(instrument));
            this.events.put((Integer)serializable, (ArrayList<NoteEvent>)arrayList);
        }
    }

    public void setTempo(float f) {
        this.tempo = f;
    }

    public void setNoteOffset(float f) {
        this.noteOffset = f;
    }

    public void setDurationFactor(float f) {
        this.durationFactor = f;
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    public synchronized void tick() {
        if (!this.paused) {
            Integer n = new Integer(this.now);
            if (this.events.containsKey(n)) {
                ArrayList<NoteEvent> arrayList = this.events.get(n);
                for (int i = 0; i < arrayList.size(); ++i) {
                    arrayList.get(i).send();
                }
                this.events.remove(n);
            }
            ++this.now;
        }
    }

    private class NoteOffEvent
    implements NoteEvent {
        private Instrument instrument;

        public NoteOffEvent(Instrument instrument) {
            this.instrument = instrument;
        }

        @Override
        public void send() {
            this.instrument.noteOff();
        }
    }

    private class NoteOnEvent
    implements NoteEvent {
        private Instrument instrument;
        private float duration;

        public NoteOnEvent(Instrument instrument, float f) {
            this.instrument = instrument;
            this.duration = f;
        }

        @Override
        public void send() {
            this.instrument.noteOn(this.duration);
        }
    }

    private static interface NoteEvent {
        public void send();
    }
}

