/*
 * Decompiled with CFR 0.152.
 */
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL2;
import processing.core.PApplet;
import processing.core.PImage;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import seltar.unzipit.UnZipIt;

public class VolumeRenderer {
    PApplet parent;
    ViewController3D vctrl;
    String glversion;
    byte[] data;
    PImage transferFunctionImage;
    FloatBuffer vertexBuffer;
    IntBuffer faceIndexBuffer;
    IntBuffer edgeIndexBuffer;
    int volumeTex;
    int tfTex;
    ShaderProgram program;
    float volSpacing;
    boolean lightEnabled;
    float lightAmbient;
    float lightDiffuse;
    float lightSpecular;
    int lightExponent;
    float tfCenter;
    float tfWidth;
    float tfDensity;
    int tfMode;
    int tfColor1;
    int tfColor2;
    float sampleStep;
    int compositeMode;
    UnZipIt z;

    VolumeRenderer(PApplet pApplet, UnZipIt unZipIt) {
        this.parent = pApplet;
        this.z = unZipIt;
        this.volumeTex = 0;
        this.tfTex = 0;
        this.vctrl = new ViewController3D(pApplet);
        this.program = new ShaderProgram(pApplet, this.z);
        this.loadShaders();
        this.lightEnabled = true;
        this.lightAmbient = 0.5f;
        this.lightDiffuse = 0.5f;
        this.lightSpecular = 0.6f;
        this.lightExponent = 10;
        this.tfCenter = 0.3f;
        this.tfWidth = 0.1f;
        this.tfDensity = 5.0f;
        this.tfMode = 0;
        this.tfColor1 = pApplet.color(255, 0, 0);
        this.tfColor2 = pApplet.color(255, 255, 255);
        this.sampleStep = 0.005f;
        this.compositeMode = 0;
        this.volSpacing = 1.0f;
    }

    void loadShaders() {
        this.program.loadShaderSources("vr.glslv", "vr.glslf");
    }

    void bindVolumeTexture(GL2 gL2) {
        if (this.volumeTex == 0) {
            int[] nArray = new int[1];
            gL2.glGenTextures(1, nArray, 0);
            this.volumeTex = nArray[0];
        }
        if (this.data != null) {
            int n = 1;
            while (this.data.length > n * n * n) {
                n *= 2;
            }
            if (n * n * n != this.data.length) {
                throw new RuntimeException("cannot determine volume size");
            }
            this.volSpacing = 1.0f / (float)n;
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.data.length);
            byteBuffer.put(this.data);
            byteBuffer.rewind();
            gL2.glActiveTexture(33984);
            gL2.glBindTexture(32879, this.volumeTex);
            gL2.glTexImage3D(32879, 0, 6409, n, n, n, 0, 6409, 5121, (Buffer)byteBuffer);
            gL2.glTexParameteri(32879, 10241, 9729);
            gL2.glTexParameteri(32879, 10240, 9729);
            gL2.glTexParameteri(32879, 10242, 33071);
            gL2.glTexParameteri(32879, 10243, 33071);
            gL2.glTexParameteri(32879, 32882, 33071);
            this.data = null;
        }
    }

    void renderCube(GL2 gL2, int n) {
        Object[] objectArray;
        if (this.vertexBuffer == null) {
            objectArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
            this.vertexBuffer = ByteBuffer.allocateDirect(4 * objectArray.length).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.vertexBuffer.put((float[])objectArray);
            this.vertexBuffer.rewind();
        }
        if (this.faceIndexBuffer == null) {
            int[] nArray = new int[24];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 3;
            nArray[5] = 2;
            nArray[6] = 6;
            nArray[7] = 7;
            nArray[8] = 7;
            nArray[9] = 6;
            nArray[10] = 5;
            nArray[11] = 4;
            nArray[12] = 4;
            nArray[13] = 5;
            nArray[14] = 1;
            nArray[16] = 5;
            nArray[17] = 6;
            nArray[18] = 2;
            nArray[19] = 1;
            nArray[20] = 7;
            nArray[21] = 4;
            nArray[23] = 3;
            objectArray = nArray;
            this.faceIndexBuffer = ByteBuffer.allocateDirect(4 * objectArray.length).order(ByteOrder.nativeOrder()).asIntBuffer();
            this.faceIndexBuffer.put((int[])objectArray);
            this.faceIndexBuffer.rewind();
        }
        if (this.edgeIndexBuffer == null) {
            int[] nArray = new int[24];
            nArray[1] = 1;
            nArray[2] = 1;
            nArray[3] = 2;
            nArray[4] = 2;
            nArray[5] = 3;
            nArray[6] = 3;
            nArray[8] = 4;
            nArray[9] = 5;
            nArray[10] = 5;
            nArray[11] = 6;
            nArray[12] = 6;
            nArray[13] = 7;
            nArray[14] = 7;
            nArray[15] = 4;
            nArray[17] = 4;
            nArray[18] = 1;
            nArray[19] = 5;
            nArray[20] = 2;
            nArray[21] = 6;
            nArray[22] = 3;
            nArray[23] = 7;
            objectArray = nArray;
            this.edgeIndexBuffer = ByteBuffer.allocateDirect(4 * objectArray.length).order(ByteOrder.nativeOrder()).asIntBuffer();
            this.edgeIndexBuffer.put((int[])objectArray);
            this.edgeIndexBuffer.rewind();
        }
        gL2.glEnableClientState(32884);
        gL2.glVertexPointer(3, 5126, 0, (Buffer)this.vertexBuffer);
        if (n == 6913) {
            gL2.glPolygonMode(1032, 6913);
            gL2.glDrawElements(7, 24, 5125, (Buffer)this.faceIndexBuffer);
            gL2.glPolygonMode(1032, 6914);
        } else {
            gL2.glEnableClientState(32886);
            gL2.glColorPointer(3, 5126, 0, (Buffer)this.vertexBuffer);
            gL2.glDrawElements(7, 24, 5125, (Buffer)this.faceIndexBuffer);
            gL2.glDisableClientState(32886);
        }
        gL2.glDisableClientState(32884);
    }

    void setUniform(GL2 gL2, String string, float f) {
        int n = gL2.glGetUniformLocation(this.program.pid, string);
        if (n >= 0) {
            gL2.glUniform1f(n, f);
        }
    }

    void setUniform(GL2 gL2, String string, int n) {
        int n2 = gL2.glGetUniformLocation(this.program.pid, string);
        if (n2 >= 0) {
            gL2.glUniform1i(n2, n);
        }
    }

    void loadUniforms(GL2 gL2) {
        if (this.sampleStep < 1.0E-4f) {
            this.sampleStep = 1.0E-4f;
        }
        this.setUniform(gL2, "vol.spacing", this.volSpacing);
        this.setUniform(gL2, "params.step", this.sampleStep);
        this.setUniform(gL2, "params.composite", this.compositeMode);
        this.setUniform(gL2, "light.enabled", this.lightEnabled ? 1 : 0);
        this.setUniform(gL2, "light.ambient", this.lightAmbient);
        this.setUniform(gL2, "light.diffuse", this.lightDiffuse);
        this.setUniform(gL2, "light.specular", this.lightSpecular);
        this.setUniform(gL2, "light.exponent", this.lightExponent);
        this.setUniform(gL2, "tf.center", this.tfCenter);
        this.setUniform(gL2, "tf.width", this.tfWidth);
        this.setUniform(gL2, "tf.density", this.tfDensity);
        this.setUniform(gL2, "tf.mode", this.tfMode);
        int n = gL2.glGetUniformLocation(this.program.pid, "tf.color1");
        if (n >= 0) {
            gL2.glUniform3f(n, this.parent.red(this.tfColor1) / 255.0f, this.parent.green(this.tfColor1) / 255.0f, this.parent.blue(this.tfColor1) / 255.0f);
        }
        if ((n = gL2.glGetUniformLocation(this.program.pid, "tf.color2")) >= 0) {
            gL2.glUniform3f(n, this.parent.red(this.tfColor2) / 255.0f, this.parent.green(this.tfColor2) / 255.0f, this.parent.blue(this.tfColor2) / 255.0f);
        }
    }

    void draw() {
        ((PGraphicsOpenGL)this.parent.g).beginPGL();
        GL2 gL2 = PGL.gl.getGL2();
        if (this.glversion == null) {
            this.glversion = "OpenGL version: " + gL2.glGetString(7938) + '\n';
            this.glversion = String.valueOf(this.glversion) + "GLSL version:   " + gL2.glGetString(35724) + '\n';
            PApplet.println((String)this.glversion);
        }
        gL2.glPushAttrib(0x4000 | 0x2000 | 8);
        gL2.glMatrixMode(5889);
        gL2.glPushMatrix();
        gL2.glLoadMatrixd(this.vctrl.prMatrix, 0);
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glLoadMatrixd(this.vctrl.mvMatrix, 0);
        gL2.glCullFace(1029);
        gL2.glEnable(2884);
        this.bindVolumeTexture(gL2);
        this.program.enable(gL2);
        this.loadUniforms(gL2);
        gL2.glEnable(3042);
        gL2.glBlendFunc(770, 771);
        gL2.glCullFace(1029);
        gL2.glEnable(2884);
        this.renderCube(gL2, 6914);
        this.program.disable(gL2);
        gL2.glMatrixMode(5889);
        gL2.glPopMatrix();
        gL2.glMatrixMode(5888);
        gL2.glPopMatrix();
        gL2.glPopAttrib();
        ((PGraphicsOpenGL)this.parent.g).endPGL();
    }

    void end() {
        this.vctrl.end();
    }

    void move(float f, float f2) {
        this.vctrl.move(f, f2);
        this.parent.redraw();
    }

    void begin(int n, float f, float f2) {
        this.vctrl.begin(n, f, f2);
        this.parent.redraw();
    }

    void home() {
        this.vctrl.home();
        this.parent.redraw();
    }

    class ShaderProgram {
        PApplet parent;
        int vid;
        int fid;
        int pid;
        String vsrc;
        String fsrc;
        UnZipIt z;

        ShaderProgram(PApplet pApplet, UnZipIt unZipIt) {
            this.parent = pApplet;
            this.pid = 0;
            this.vid = 0;
            this.fid = 0;
            this.z = unZipIt;
        }

        void setVertexShader(String string) {
            this.vsrc = string;
        }

        void setFragmentShader(String string) {
            this.fsrc = string;
        }

        void loadShaderSources(String string, String string2) {
            if (string != null) {
                this.vsrc = this.z.loadString(string);
            }
            if (string2 != null) {
                this.fsrc = this.z.loadString(string2);
            }
        }

        boolean compileShader(GL2 gL2, int n) {
            boolean bl;
            gL2.glCompileShader(n);
            int[] nArray = new int[1];
            gL2.glGetShaderiv(n, 35713, nArray, 0);
            boolean bl2 = bl = nArray[0] == 1;
            if (!bl) {
                gL2.glGetShaderiv(n, 35663, nArray, 0);
                int n2 = nArray[0];
                if (n2 == 35632) {
                    PApplet.print((String)"fragment");
                } else if (n2 == 35633) {
                    PApplet.print((String)"vertex");
                }
                PApplet.println((String)" shader failed to compile --------");
                gL2.glGetShaderiv(n, 35716, nArray, 0);
                int cfr_ignored_0 = nArray[0];
                if (nArray[0] > 0) {
                    byte[] byArray = new byte[nArray[0]];
                    gL2.glGetShaderInfoLog(n, nArray[0], null, 0, byArray, 0);
                    PApplet.println((String)new String(byArray));
                }
                return false;
            }
            return true;
        }

        void enable(GL2 gL2) {
            String[] stringArray;
            if (this.pid == 0) {
                this.pid = gL2.glCreateProgram();
                this.vid = gL2.glCreateShader(35633);
                gL2.glAttachShader(this.pid, this.vid);
                this.fid = gL2.glCreateShader(35632);
                gL2.glAttachShader(this.pid, this.fid);
            }
            boolean bl = false;
            if (this.vsrc != null) {
                stringArray = new String[]{this.vsrc};
                gL2.glShaderSource(this.vid, stringArray.length, stringArray, null, 0);
                this.vsrc = null;
                bl = true;
            }
            if (this.fsrc != null) {
                stringArray = new String[]{this.fsrc};
                gL2.glShaderSource(this.fid, stringArray.length, stringArray, null, 0);
                this.fsrc = null;
                bl = true;
            }
            if (!(!bl || this.compileShader(gL2, this.vid) && this.compileShader(gL2, this.fid) && this.linkProgram(gL2, this.pid))) {
                this.setDefaultProgram();
                stringArray = new String[]{this.vsrc};
                gL2.glShaderSource(this.vid, stringArray.length, stringArray, null, 0);
                stringArray = new String[]{this.fsrc};
                gL2.glShaderSource(this.fid, stringArray.length, stringArray, null, 0);
                this.compileShader(gL2, this.vid);
                this.compileShader(gL2, this.fid);
                this.linkProgram(gL2, this.pid);
            }
            gL2.glUseProgram(this.pid);
        }

        void disable(GL2 gL2) {
            gL2.glUseProgram(0);
        }

        void setDefaultProgram() {
            String[] stringArray = new String[]{"varying vec3 pos; void main() { pos = gl_Vertex.xyz; gl_Position = ftransform(); }", "varying vec3 pos; void main() { gl_FragColor = vec4( abs(cos(31.415926536*pos)), 1.0 ); }"};
            this.vsrc = stringArray[0];
            this.fsrc = stringArray[1];
        }

        boolean linkProgram(GL2 gL2, int n) {
            boolean bl;
            gL2.glLinkProgram(n);
            int[] nArray = new int[1];
            gL2.glGetProgramiv(n, 35714, nArray, 0);
            boolean bl2 = bl = nArray[0] == 1;
            if (!bl) {
                PApplet.println((String)"GLSL program failed to link --------");
                gL2.glGetProgramiv(n, 35716, nArray, 0);
                int cfr_ignored_0 = nArray[0];
                if (nArray[0] > 0) {
                    byte[] byArray = new byte[nArray[0]];
                    gL2.glGetProgramInfoLog(n, nArray[0], null, 0, byArray, 0);
                    PApplet.println((String)new String(byArray));
                }
            }
            return bl;
        }
    }
}

