/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.windows.WindowsGraphicsDevice;
import com.jogamp.opengl.GLRendererQuirks;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.WrappedSurface;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.GDIDummyUpstreamSurfaceHook;
import jogamp.nativewindow.windows.GDISurface;
import jogamp.nativewindow.windows.RegisteredClassFactory;
import jogamp.opengl.DesktopGLDynamicLookupHelper;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.SharedResourceRunner;
import jogamp.opengl.windows.wgl.WGL;
import jogamp.opengl.windows.wgl.WindowsBitmapWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsExternalWGLContext;
import jogamp.opengl.windows.wgl.WindowsExternalWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsOnscreenWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsPbufferWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLDynamicLibraryBundleInfo;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;

public class WindowsWGLDrawableFactory
extends GLDrawableFactoryImpl {
    private static DesktopGLDynamicLookupHelper windowsWGLDynamicLookupHelper = null;
    private WindowsGraphicsDevice defaultDevice;
    private SharedResourceRunner sharedResourceRunner;
    private HashMap<String, SharedResourceRunner.Resource> sharedMap;
    private long processAffinityChanges = 0L;
    private PointerBuffer procMask = PointerBuffer.allocateDirect((int)1);
    private PointerBuffer sysMask = PointerBuffer.allocateDirect((int)1);
    static final String WGL_ARB_pbuffer = "WGL_ARB_pbuffer";
    static final String WGL_ARB_pixel_format = "WGL_ARB_pixel_format";
    static final String WGL_ARB_multisample = "WGL_ARB_multisample";
    static final String WGL_NV_float_buffer = "WGL_NV_float_buffer";
    static final String WGL_ARB_make_current_read = "WGL_ARB_make_current_read";
    static final String wglMakeContextCurrent = "wglMakeContextCurrent";
    private static final int GAMMA_RAMP_LENGTH = 256;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowsWGLDrawableFactory() {
        Class<WindowsWGLDrawableFactory> clazz = WindowsWGLDrawableFactory.class;
        synchronized (WindowsWGLDrawableFactory.class) {
            if (null == windowsWGLDynamicLookupHelper) {
                DesktopGLDynamicLookupHelper desktopGLDynamicLookupHelper;
                block11: {
                    desktopGLDynamicLookupHelper = null;
                    try {
                        desktopGLDynamicLookupHelper = new DesktopGLDynamicLookupHelper(new WindowsWGLDynamicLibraryBundleInfo());
                    }
                    catch (GLException gLException) {
                        if (!DEBUG) break block11;
                        gLException.printStackTrace();
                    }
                }
                if (null != desktopGLDynamicLookupHelper && desktopGLDynamicLookupHelper.isLibComplete()) {
                    windowsWGLDynamicLookupHelper = desktopGLDynamicLookupHelper;
                    WGL.getWGLProcAddressTable().reset((DynamicLookupHelper)windowsWGLDynamicLookupHelper);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.defaultDevice = new WindowsGraphicsDevice(0);
            if (null != windowsWGLDynamicLookupHelper) {
                WindowsWGLGraphicsConfigurationFactory.registerFactory();
                if (GLProfile.isAWTAvailable()) {
                    try {
                        ReflectionUtil.callStaticMethod((String)"jogamp.opengl.windows.wgl.awt.WindowsAWTWGLGraphicsConfigurationFactory", (String)"registerFactory", null, null, (ClassLoader)this.getClass().getClassLoader());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.sharedMap = new HashMap();
                this.sharedResourceRunner = new SharedResourceRunner(new SharedResourceImplementation());
                this.sharedResourceRunner.start();
            }
            return;
        }
    }

    @Override
    protected final boolean isComplete() {
        return null != windowsWGLDynamicLookupHelper;
    }

    @Override
    protected final void destroy() {
        if (null != this.sharedResourceRunner) {
            this.sharedResourceRunner.stop();
            this.sharedResourceRunner = null;
        }
        if (null != this.sharedMap) {
            this.sharedMap.clear();
            this.sharedMap = null;
        }
        this.defaultDevice = null;
        windowsWGLDynamicLookupHelper = null;
        RegisteredClassFactory.shutdownSharedClasses();
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper(int n) {
        return windowsWGLDynamicLookupHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void enterThreadCriticalZone() {
        PointerBuffer pointerBuffer = this.sysMask;
        synchronized (pointerBuffer) {
            long l;
            if (0L == this.processAffinityChanges && GDI.GetProcessAffinityMask(l = GDI.GetCurrentProcess(), this.procMask, this.sysMask)) {
                if (DEBUG) {
                    System.err.println("WindowsWGLDrawableFactory.enterThreadCriticalZone() - 0x" + Long.toHexString(l) + " - " + WindowsWGLDrawableFactory.getThreadName());
                }
                this.processAffinityChanges = l;
                GDI.SetProcessAffinityMask(l, 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void leaveThreadCriticalZone() {
        PointerBuffer pointerBuffer = this.sysMask;
        synchronized (pointerBuffer) {
            if (0L != this.processAffinityChanges) {
                long l = GDI.GetCurrentProcess();
                if (l != this.processAffinityChanges) {
                    throw new GLException("PID doesn't match: set PID 0x" + Long.toHexString(this.processAffinityChanges) + " this PID 0x" + Long.toHexString(l));
                }
                if (DEBUG) {
                    System.err.println("WindowsWGLDrawableFactory.leaveThreadCriticalZone() - 0x" + Long.toHexString(l) + " - " + WindowsWGLDrawableFactory.getThreadName());
                }
                GDI.SetProcessAffinityMask(l, this.sysMask.get(0));
            }
        }
    }

    @Override
    public final AbstractGraphicsDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public final boolean getIsDeviceCompatible(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != windowsWGLDynamicLookupHelper && abstractGraphicsDevice instanceof WindowsGraphicsDevice;
    }

    @Override
    protected final Thread getSharedResourceThread() {
        return this.sharedResourceRunner.start();
    }

    @Override
    protected final SharedResource getOrCreateSharedResourceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
    }

    protected final WindowsWGLDrawable getOrCreateSharedDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = this.getOrCreateSharedResourceImpl(abstractGraphicsDevice);
        if (null != sharedResource) {
            return (WindowsWGLDrawable)sharedResource.getDrawable();
        }
        return null;
    }

    @Override
    protected List<GLCapabilitiesImmutable> getAvailableCapabilitiesImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return WindowsWGLGraphicsConfigurationFactory.getAvailableCapabilities(this, abstractGraphicsDevice);
    }

    @Override
    protected final GLDrawableImpl createOnscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        return new WindowsOnscreenWGLDrawable(this, nativeSurface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final GLDrawableImpl createOffscreenDrawableImpl(NativeSurface nativeSurface) {
        WindowsPbufferWGLDrawable windowsPbufferWGLDrawable;
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            return WindowsBitmapWGLDrawable.create(this, nativeSurface);
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        SharedResource sharedResource = this.getOrCreateSharedResourceImpl(abstractGraphicsDevice);
        if (null != sharedResource) {
            GLContext gLContext = GLContext.getCurrent();
            if (gLContext != null) {
                gLContext.release();
            }
            sharedResource.context.makeCurrent();
            try {
                windowsPbufferWGLDrawable = new WindowsPbufferWGLDrawable(this, nativeSurface);
            }
            finally {
                sharedResource.context.release();
                if (gLContext != null) {
                    gLContext.makeCurrent();
                }
            }
        } else {
            windowsPbufferWGLDrawable = new WindowsPbufferWGLDrawable(this, nativeSurface);
        }
        return windowsPbufferWGLDrawable;
    }

    public final int isReadDrawableAvailable(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = this.getOrCreateSharedResourceImpl(null != abstractGraphicsDevice ? abstractGraphicsDevice : this.defaultDevice);
        if (null != sharedResource) {
            return sharedResource.hasReadDrawable() ? 1 : 0;
        }
        return -1;
    }

    @Override
    public final boolean canCreateGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = this.getOrCreateSharedResourceImpl(null != abstractGraphicsDevice ? abstractGraphicsDevice : this.defaultDevice);
        if (null != sharedResource) {
            return sharedResource.hasARBPBuffer();
        }
        return false;
    }

    @Override
    protected final ProxySurface createMutableSurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        WindowsGraphicsDevice windowsGraphicsDevice = bl || !(abstractGraphicsDevice instanceof WindowsGraphicsDevice) ? new WindowsGraphicsDevice(abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID()) : (WindowsGraphicsDevice)abstractGraphicsDevice;
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(windowsGraphicsDevice, 0);
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, defaultGraphicsScreen);
        if (null == windowsWGLGraphicsConfiguration) {
            throw new GLException("Choosing GraphicsConfiguration failed w/ " + gLCapabilitiesImmutable + " on " + defaultGraphicsScreen);
        }
        return new WrappedSurface(windowsWGLGraphicsConfiguration, 0L, upstreamSurfaceHook, bl);
    }

    @Override
    public final ProxySurface createDummySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        WindowsGraphicsDevice windowsGraphicsDevice = bl || !(abstractGraphicsDevice instanceof WindowsGraphicsDevice) ? new WindowsGraphicsDevice(abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID()) : (WindowsGraphicsDevice)abstractGraphicsDevice;
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(windowsGraphicsDevice, 0);
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixOnscreenGLCapabilities(gLCapabilitiesImmutable), gLCapabilitiesImmutable2, gLCapabilitiesChooser, defaultGraphicsScreen);
        if (null == windowsWGLGraphicsConfiguration) {
            throw new GLException("Choosing GraphicsConfiguration failed w/ " + gLCapabilitiesImmutable + " on " + defaultGraphicsScreen);
        }
        return new GDISurface(windowsWGLGraphicsConfiguration, 0L, new GDIDummyUpstreamSurfaceHook(n, n2), bl);
    }

    @Override
    protected final ProxySurface createProxySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, int n, long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        WindowsGraphicsDevice windowsGraphicsDevice = new WindowsGraphicsDevice(abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID());
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(windowsGraphicsDevice, n);
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, gLCapabilitiesChooser, defaultGraphicsScreen);
        return new GDISurface(windowsWGLGraphicsConfiguration, l, upstreamSurfaceHook, true);
    }

    @Override
    protected final GLContext createExternalGLContextImpl() {
        return WindowsExternalWGLContext.create(this, null);
    }

    @Override
    public final boolean canCreateExternalGLDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return true;
    }

    @Override
    protected final GLDrawable createExternalGLDrawableImpl() {
        return WindowsExternalWGLDrawable.create(this, null);
    }

    static String wglGetLastError() {
        long l = GDI.GetLastError();
        String string = null;
        switch ((int)l) {
            case 0: {
                string = "ERROR_SUCCESS";
                break;
            }
            case 2000: {
                string = "ERROR_INVALID_PIXEL_FORMAT";
                break;
            }
            case 1450: {
                string = "ERROR_NO_SYSTEM_RESOURCES";
                break;
            }
            case 13: {
                string = "ERROR_INVALID_DATA";
                break;
            }
            case 127: {
                string = "ERROR_PROC_NOT_FOUND";
                break;
            }
            case 1400: {
                string = "ERROR_INVALID_WINDOW_HANDLE";
                break;
            }
            default: {
                string = "(Unknown error code " + l + ")";
            }
        }
        return string;
    }

    @Override
    protected final int getGammaRampLength() {
        return 256;
    }

    @Override
    protected final boolean setGammaRamp(float[] fArray) {
        short[] sArray = new short[768];
        for (int i = 0; i < 256; ++i) {
            short s;
            sArray[i] = s = (short)(fArray[i] * 65535.0f);
            sArray[i + 256] = s;
            sArray[i + 512] = s;
        }
        long l = GDI.GetDC(0L);
        boolean bl = GDI.SetDeviceGammaRamp(l, ShortBuffer.wrap(sArray));
        GDI.ReleaseDC(0L, l);
        return bl;
    }

    @Override
    protected final Buffer getGammaRamp() {
        ShortBuffer shortBuffer = ShortBuffer.wrap(new short[768]);
        long l = GDI.GetDC(0L);
        boolean bl = GDI.GetDeviceGammaRamp(l, shortBuffer);
        GDI.ReleaseDC(0L, l);
        if (!bl) {
            return null;
        }
        return shortBuffer;
    }

    @Override
    protected final void resetGammaRamp(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        long l = GDI.GetDC(0L);
        GDI.SetDeviceGammaRamp(l, buffer);
        GDI.ReleaseDC(0L, l);
    }

    class SharedResourceImplementation
    implements SharedResourceRunner.Implementation {
        SharedResourceImplementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            HashMap hashMap = WindowsWGLDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                WindowsWGLDrawableFactory.this.sharedMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedResourceRunner.Resource mapPut(String string, SharedResourceRunner.Resource resource) {
            HashMap hashMap = WindowsWGLDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                return WindowsWGLDrawableFactory.this.sharedMap.put(string, resource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedResourceRunner.Resource mapGet(String string) {
            HashMap hashMap = WindowsWGLDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                return (SharedResourceRunner.Resource)WindowsWGLDrawableFactory.this.sharedMap.get(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<SharedResourceRunner.Resource> mapValues() {
            HashMap hashMap = WindowsWGLDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                return WindowsWGLDrawableFactory.this.sharedMap.values();
            }
        }

        @Override
        public boolean isDeviceSupported(String string) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedResourceRunner.Resource createSharedResource(String string) {
            WindowsGraphicsDevice windowsGraphicsDevice = new WindowsGraphicsDevice(string, 0);
            windowsGraphicsDevice.lock();
            try {
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(windowsGraphicsDevice, 0);
                GLProfile gLProfile = GLProfile.get(windowsGraphicsDevice, GLProfile.GL_PROFILE_LIST_MIN_DESKTOP, false);
                if (null == gLProfile) {
                    throw new GLException("Couldn't get default GLProfile for device: " + windowsGraphicsDevice);
                }
                GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
                GLDrawableImpl gLDrawableImpl = WindowsWGLDrawableFactory.this.createOnscreenDrawableImpl(WindowsWGLDrawableFactory.this.createDummySurfaceImpl(windowsGraphicsDevice, false, gLCapabilities, gLCapabilities, null, 64, 64));
                gLDrawableImpl.setRealized(true);
                GLContextImpl gLContextImpl = (GLContextImpl)gLDrawableImpl.createContext(null);
                if (null == gLContextImpl) {
                    throw new GLException("Couldn't create shared context for drawable: " + gLDrawableImpl);
                }
                gLContextImpl.makeCurrent();
                try {
                    bl4 = gLContextImpl.isExtensionAvailable(WindowsWGLDrawableFactory.WGL_ARB_pixel_format);
                    bl3 = gLContextImpl.isExtensionAvailable(WindowsWGLDrawableFactory.WGL_ARB_multisample);
                    bl2 = gLContextImpl.isExtensionAvailable("GL_ARB_pbuffer");
                    bl = gLContextImpl.isExtensionAvailable(WindowsWGLDrawableFactory.WGL_ARB_make_current_read) && gLContextImpl.isFunctionAvailable(WindowsWGLDrawableFactory.wglMakeContextCurrent);
                }
                finally {
                    gLContextImpl.release();
                }
                if (DEBUG) {
                    System.err.println("SharedDevice:  " + windowsGraphicsDevice);
                    System.err.println("SharedScreen:  " + defaultGraphicsScreen);
                    System.err.println("SharedContext: " + gLContextImpl);
                    System.err.println("pixelformat:   " + bl4);
                    System.err.println("multisample:   " + bl3);
                    System.err.println("pbuffer:       " + bl2);
                    System.err.println("readDrawable:  " + bl);
                }
                SharedResource sharedResource = new SharedResource(windowsGraphicsDevice, defaultGraphicsScreen, gLDrawableImpl, gLContextImpl, bl4, bl3, bl2, bl);
                return sharedResource;
            }
            catch (Throwable throwable) {
                throw new GLException("WindowsWGLDrawableFactory - Could not initialize shared resources for " + string, throwable);
            }
            finally {
                windowsGraphicsDevice.unlock();
            }
        }

        @Override
        public void releaseSharedResource(SharedResourceRunner.Resource resource) {
            SharedResource sharedResource = (SharedResource)resource;
            if (DEBUG) {
                System.err.println("Shutdown Shared:");
                System.err.println("Device  : " + sharedResource.device);
                System.err.println("Screen  : " + sharedResource.screen);
                System.err.println("Drawable: " + sharedResource.drawable);
                System.err.println("CTX     : " + sharedResource.context);
            }
            if (null != sharedResource.context) {
                sharedResource.context = null;
            }
            if (null != sharedResource.drawable) {
                sharedResource.drawable.setRealized(false);
                sharedResource.drawable = null;
            }
            if (null != sharedResource.screen) {
                sharedResource.screen = null;
            }
            if (null != sharedResource.device) {
                sharedResource.device.close();
                sharedResource.device = null;
            }
        }
    }

    static class SharedResource
    implements SharedResourceRunner.Resource {
        private final boolean hasARBPixelFormat;
        private final boolean hasARBMultisample;
        private final boolean hasARBPBuffer;
        private final boolean hasARBReadDrawable;
        private WindowsGraphicsDevice device;
        private AbstractGraphicsScreen screen;
        private GLDrawableImpl drawable;
        private GLContextImpl context;

        SharedResource(WindowsGraphicsDevice windowsGraphicsDevice, AbstractGraphicsScreen abstractGraphicsScreen, GLDrawableImpl gLDrawableImpl, GLContextImpl gLContextImpl, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.device = windowsGraphicsDevice;
            this.screen = abstractGraphicsScreen;
            this.drawable = gLDrawableImpl;
            this.context = gLContextImpl;
            this.hasARBPixelFormat = bl;
            this.hasARBMultisample = bl2;
            this.hasARBPBuffer = bl3;
            this.hasARBReadDrawable = bl4;
        }

        @Override
        public final boolean isValid() {
            return null != this.context;
        }

        @Override
        public final AbstractGraphicsDevice getDevice() {
            return this.device;
        }

        @Override
        public final AbstractGraphicsScreen getScreen() {
            return this.screen;
        }

        @Override
        public final GLDrawableImpl getDrawable() {
            return this.drawable;
        }

        @Override
        public final GLContextImpl getContext() {
            return this.context;
        }

        @Override
        public GLRendererQuirks getRendererQuirks() {
            return null != this.context ? this.context.getRendererQuirks() : null;
        }

        final boolean hasARBPixelFormat() {
            return this.hasARBPixelFormat;
        }

        final boolean hasARBMultisample() {
            return this.hasARBMultisample;
        }

        final boolean hasARBPBuffer() {
            return this.hasARBPBuffer;
        }

        final boolean hasReadDrawable() {
            return this.hasARBReadDrawable;
        }
    }
}

