/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event;

import com.jogamp.common.util.IntBitfield;
import com.jogamp.newt.event.InputEvent;

public class KeyEvent
extends InputEvent {
    private final short keyCode;
    private final short keySym;
    private final char keyChar;
    private final byte flags;
    private static final byte F_MODIFIER_MASK = 1;
    private static final byte F_ACTION_MASK = 2;
    private static final byte F_PRINTABLE_MASK = 4;
    public static final short EVENT_KEY_PRESSED = 300;
    public static final short EVENT_KEY_RELEASED = 301;
    public static final short EVENT_KEY_TYPED = 302;
    public static final char NULL_CHAR = '\u0000';
    public static final NonPrintableRange[] nonPrintableKeys = new NonPrintableRange[]{new NonPrintableRange(0, 31, true), new NonPrintableRange(97, 120, false), new NonPrintableRange(143, 159, true), new NonPrintableRange(-8192, -1793, true)};
    public static final short VK_UNDEFINED = 0;
    static final short VK_FREE01 = 1;
    public static final short VK_HOME = 2;
    public static final short VK_END = 3;
    public static final short VK_FINAL = 4;
    public static final short VK_PRINTSCREEN = 5;
    static final short VK_FREE06 = 6;
    static final short VK_FREE07 = 7;
    public static final short VK_BACK_SPACE = 8;
    public static final short VK_TAB = 9;
    public static final short VK_ENTER = 10;
    public static final short VK_PAGE_DOWN = 11;
    public static final short VK_CLEAR = 12;
    static final short VK_FREE0D = 13;
    static final short VK_FREE0E = 14;
    public static final short VK_SHIFT = 15;
    public static final short VK_PAGE_UP = 16;
    public static final short VK_CONTROL = 17;
    public static final short VK_ALT = 18;
    public static final short VK_ALT_GRAPH = 19;
    public static final short VK_CAPS_LOCK = 20;
    static final short VK_FREE15 = 21;
    public static final short VK_PAUSE = 22;
    public static final short VK_SCROLL_LOCK = 23;
    public static final short VK_CANCEL = 24;
    static final short VK_FREE19 = 25;
    public static final short VK_INSERT = 26;
    public static final short VK_ESCAPE = 27;
    public static final short VK_CONVERT = 28;
    public static final short VK_NONCONVERT = 29;
    public static final short VK_ACCEPT = 30;
    public static final short VK_MODECHANGE = 31;
    public static final short VK_SPACE = 32;
    public static final short VK_EXCLAMATION_MARK = 33;
    public static final short VK_QUOTEDBL = 34;
    public static final short VK_NUMBER_SIGN = 35;
    public static final short VK_DOLLAR = 36;
    public static final short VK_PERCENT = 37;
    public static final short VK_AMPERSAND = 38;
    public static final short VK_QUOTE = 39;
    public static final short VK_LEFT_PARENTHESIS = 40;
    public static final short VK_RIGHT_PARENTHESIS = 41;
    public static final short VK_ASTERISK = 42;
    public static final short VK_PLUS = 43;
    public static final short VK_COMMA = 44;
    public static final short VK_MINUS = 45;
    public static final short VK_PERIOD = 46;
    public static final short VK_SLASH = 47;
    public static final short VK_0 = 48;
    public static final short VK_1 = 49;
    public static final short VK_2 = 50;
    public static final short VK_3 = 51;
    public static final short VK_4 = 52;
    public static final short VK_5 = 53;
    public static final short VK_6 = 54;
    public static final short VK_7 = 55;
    public static final short VK_8 = 56;
    public static final short VK_9 = 57;
    public static final short VK_COLON = 58;
    public static final short VK_SEMICOLON = 59;
    public static final short VK_LESS = 60;
    public static final short VK_EQUALS = 61;
    public static final short VK_GREATER = 62;
    public static final short VK_QUESTIONMARK = 63;
    public static final short VK_AT = 64;
    public static final short VK_A = 65;
    public static final short VK_B = 66;
    public static final short VK_C = 67;
    public static final short VK_D = 68;
    public static final short VK_E = 69;
    public static final short VK_F = 70;
    public static final short VK_G = 71;
    public static final short VK_H = 72;
    public static final short VK_I = 73;
    public static final short VK_J = 74;
    public static final short VK_K = 75;
    public static final short VK_L = 76;
    public static final short VK_M = 77;
    public static final short VK_N = 78;
    public static final short VK_O = 79;
    public static final short VK_P = 80;
    public static final short VK_Q = 81;
    public static final short VK_R = 82;
    public static final short VK_S = 83;
    public static final short VK_T = 84;
    public static final short VK_U = 85;
    public static final short VK_V = 86;
    public static final short VK_W = 87;
    public static final short VK_X = 88;
    public static final short VK_Y = 89;
    public static final short VK_Z = 90;
    public static final short VK_OPEN_BRACKET = 91;
    public static final short VK_BACK_SLASH = 92;
    public static final short VK_CLOSE_BRACKET = 93;
    public static final short VK_CIRCUMFLEX = 94;
    public static final short VK_UNDERSCORE = 95;
    public static final short VK_BACK_QUOTE = 96;
    public static final short VK_F1 = 97;
    public static final short VK_F2 = 98;
    public static final short VK_F3 = 99;
    public static final short VK_F4 = 100;
    public static final short VK_F5 = 101;
    public static final short VK_F6 = 102;
    public static final short VK_F7 = 103;
    public static final short VK_F8 = 104;
    public static final short VK_F9 = 105;
    public static final short VK_F10 = 106;
    public static final short VK_F11 = 107;
    public static final short VK_F12 = 108;
    public static final short VK_F13 = 109;
    public static final short VK_F14 = 110;
    public static final short VK_F15 = 111;
    public static final short VK_F16 = 112;
    public static final short VK_F17 = 113;
    public static final short VK_F18 = 114;
    public static final short VK_F19 = 115;
    public static final short VK_F20 = 116;
    public static final short VK_F21 = 117;
    public static final short VK_F22 = 118;
    public static final short VK_F23 = 119;
    public static final short VK_F24 = 120;
    public static final short VK_LEFT_BRACE = 123;
    public static final short VK_PIPE = 124;
    public static final short VK_RIGHT_BRACE = 125;
    public static final short VK_TILDE = 126;
    public static final short VK_SEPARATOR = 127;
    public static final short VK_NUMPAD0 = 128;
    public static final short VK_NUMPAD1 = 129;
    public static final short VK_NUMPAD2 = 130;
    public static final short VK_NUMPAD3 = 131;
    public static final short VK_NUMPAD4 = 132;
    public static final short VK_NUMPAD5 = 133;
    public static final short VK_NUMPAD6 = 134;
    public static final short VK_NUMPAD7 = 135;
    public static final short VK_NUMPAD8 = 136;
    public static final short VK_NUMPAD9 = 137;
    public static final short VK_DECIMAL = 138;
    public static final short VK_ADD = 139;
    public static final short VK_SUBTRACT = 140;
    public static final short VK_MULTIPLY = 141;
    public static final short VK_DIVIDE = 142;
    public static final short VK_DELETE = 147;
    public static final short VK_NUM_LOCK = 148;
    public static final short VK_LEFT = 149;
    public static final short VK_UP = 150;
    public static final short VK_RIGHT = 151;
    public static final short VK_DOWN = 152;
    public static final short VK_CONTEXT_MENU = 153;
    public static final short VK_WINDOWS = 154;
    public static final short VK_META = 155;
    public static final short VK_HELP = 156;
    public static final short VK_COMPOSE = 157;
    public static final short VK_BEGIN = 158;
    public static final short VK_STOP = 159;
    public static final short VK_INVERTED_EXCLAMATION_MARK = 161;
    public static final short VK_EURO_SIGN = 8364;
    public static final short VK_CUT = -1927;
    public static final short VK_COPY = -1926;
    public static final short VK_PASTE = -1925;
    public static final short VK_UNDO = -1924;
    public static final short VK_AGAIN = -1923;
    public static final short VK_FIND = -1922;
    public static final short VK_PROPS = -1921;
    public static final short VK_INPUT_METHOD_ON_OFF = -1904;
    public static final short VK_CODE_INPUT = -1903;
    public static final short VK_ROMAN_CHARACTERS = -1902;
    public static final short VK_ALL_CANDIDATES = -1901;
    public static final short VK_PREVIOUS_CANDIDATE = -1900;
    public static final short VK_ALPHANUMERIC = -1899;
    public static final short VK_KATAKANA = -1898;
    public static final short VK_HIRAGANA = -1897;
    public static final short VK_FULL_WIDTH = -1896;
    public static final short VK_HALF_WIDTH = -1894;
    public static final short VK_JAPANESE_KATAKANA = -1893;
    public static final short VK_JAPANESE_HIRAGANA = -1892;
    public static final short VK_JAPANESE_ROMAN = -1891;
    public static final short VK_KANA_LOCK = -1889;
    public static final short VK_KEYBOARD_INVISIBLE = -1793;

    private KeyEvent(short s, Object object, long l, int n, short s2, short s3, int n2, char c) {
        super(s, object, l, n | n2);
        this.keyCode = s2;
        this.keySym = s3;
        this.keyChar = c;
        int n3 = 0;
        n3 = KeyEvent.isPrintableKey(s3, false) && KeyEvent.isPrintableKey((short)c, true) ? (int)((byte)(n3 | 4)) : (0 != n2 ? (int)((byte)(n3 | 1)) : (int)((byte)(n3 | 2)));
        this.flags = (byte)n3;
        int n4 = this.flags & 7;
        int n5 = IntBitfield.getBitCount((int)n4);
        if (1 != n5) {
            throw new InternalError("Key must be either of type printable, modifier or action - but it is of " + n5 + " types: " + this);
        }
    }

    public static KeyEvent create(short s, Object object, long l, int n, short s2, short s3, char c) {
        return new KeyEvent(s, object, l, n, s2, s3, KeyEvent.getModifierMask(s3), c);
    }

    public final char getKeyChar() {
        return this.keyChar;
    }

    public final short getKeySymbol() {
        return this.keySym;
    }

    public final short getKeyCode() {
        return this.keyCode;
    }

    @Override
    public final String toString() {
        return this.toString(null).toString();
    }

    @Override
    public final StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("KeyEvent[").append(KeyEvent.getEventTypeString(this.getEventType())).append(", code ").append(KeyEvent.toHexString(this.keyCode)).append(", sym ").append(KeyEvent.toHexString(this.keySym)).append(", char '").append(this.keyChar).append("' (").append(KeyEvent.toHexString((short)this.keyChar)).append("), printable ").append(this.isPrintableKey()).append(", modifier ").append(this.isModifierKey()).append(", action ").append(this.isActionKey()).append(", ");
        return super.toString(stringBuilder).append("]");
    }

    public static String getEventTypeString(short s) {
        switch (s) {
            case 300: {
                return "EVENT_KEY_PRESSED";
            }
            case 301: {
                return "EVENT_KEY_RELEASED";
            }
            case 302: {
                return "EVENT_KEY_TYPED";
            }
        }
        return "unknown (" + s + ")";
    }

    public static short utf16ToVKey(char c) {
        if ('a' <= c && c <= 'z') {
            return (short)(c - 97 + 65);
        }
        return (short)c;
    }

    public static boolean isModifierKey(short s) {
        switch (s) {
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 155: {
                return true;
            }
        }
        return false;
    }

    public static int getModifierMask(short s) {
        switch (s) {
            case 15: {
                return 1;
            }
            case 17: {
                return 2;
            }
            case 18: 
            case 19: {
                return 8;
            }
            case 155: {
                return 4;
            }
        }
        return 0;
    }

    public final boolean isModifierKey() {
        return 0 != (1 & this.flags);
    }

    public final boolean isActionKey() {
        return 0 != (2 & this.flags);
    }

    public static boolean isPrintableKey(short s, boolean bl) {
        if (0 == s) {
            return false;
        }
        return !(!bl ? KeyEvent.nonPrintableKeys[0].min <= s && s <= KeyEvent.nonPrintableKeys[0].max || KeyEvent.nonPrintableKeys[1].min <= s && s <= KeyEvent.nonPrintableKeys[1].max || KeyEvent.nonPrintableKeys[2].min <= s && s <= KeyEvent.nonPrintableKeys[2].max || KeyEvent.nonPrintableKeys[3].min <= s && s <= KeyEvent.nonPrintableKeys[3].max : KeyEvent.nonPrintableKeys[0].inclKeyChar && KeyEvent.nonPrintableKeys[0].min <= s && s <= KeyEvent.nonPrintableKeys[0].max || KeyEvent.nonPrintableKeys[1].inclKeyChar && KeyEvent.nonPrintableKeys[1].min <= s && s <= KeyEvent.nonPrintableKeys[1].max || KeyEvent.nonPrintableKeys[2].inclKeyChar && KeyEvent.nonPrintableKeys[2].min <= s && s <= KeyEvent.nonPrintableKeys[2].max || KeyEvent.nonPrintableKeys[3].inclKeyChar && KeyEvent.nonPrintableKeys[3].min <= s && s <= KeyEvent.nonPrintableKeys[3].max);
    }

    public final boolean isPrintableKey() {
        return 0 != (4 & this.flags);
    }

    public static class NonPrintableRange {
        public short min;
        public short max;
        public final boolean inclKeyChar;

        private NonPrintableRange(short s, short s2, boolean bl) {
            this.min = s;
            this.max = s2;
            this.inclKeyChar = bl;
        }
    }
}

