/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import processing.core.PApplet;
import processing.data.Sort;

public class IntList
implements Iterable<Integer> {
    protected int count;
    protected int[] data;

    public IntList() {
        this.data = new int[10];
    }

    public IntList(int length) {
        this.data = new int[length];
    }

    public IntList(int[] source) {
        this.count = source.length;
        this.data = new int[this.count];
        System.arraycopy(source, 0, this.data, 0, this.count);
    }

    public IntList(Iterable<Integer> iter) {
        this(10);
        for (int v : iter) {
            this.append(v);
        }
    }

    private void crop() {
        if (this.count != this.data.length) {
            this.data = PApplet.subset(this.data, 0, this.count);
        }
    }

    public int size() {
        return this.count;
    }

    public void resize(int length) {
        if (length > this.data.length) {
            int[] temp = new int[length];
            System.arraycopy(this.data, 0, temp, 0, this.count);
            this.data = temp;
        } else if (length > this.count) {
            Arrays.fill(this.data, this.count, length, 0);
        }
        this.count = length;
    }

    public void clear() {
        this.count = 0;
    }

    public int get(int index) {
        return this.data[index];
    }

    public void set(int index, int what) {
        if (index >= this.count) {
            this.data = PApplet.expand(this.data, index + 1);
            for (int i = this.count; i < index; ++i) {
                this.data[i] = 0;
            }
            this.count = index + 1;
        }
        this.data[index] = what;
    }

    public int remove(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int entry = this.data[index];
        for (int i = index; i < this.count - 1; ++i) {
            this.data[i] = this.data[i + 1];
        }
        --this.count;
        return entry;
    }

    public int removeValue(int value) {
        int index = this.index(value);
        if (index != -1) {
            this.remove(index);
            return index;
        }
        return -1;
    }

    public int removeValues(int value) {
        int ii = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] == value) continue;
            this.data[ii++] = this.data[i];
        }
        int removed = this.count - ii;
        this.count = ii;
        return removed;
    }

    public void append(int value) {
        if (this.count == this.data.length) {
            this.data = PApplet.expand(this.data);
        }
        this.data[this.count++] = value;
    }

    public void append(int[] values) {
        for (int v : values) {
            this.append(v);
        }
    }

    public void append(IntList list) {
        for (int v : list.values()) {
            this.append(v);
        }
    }

    public void insert(int index, int[] values) {
        if (index < 0) {
            throw new IllegalArgumentException("insert() index cannot be negative: it was " + index);
        }
        if (index >= values.length) {
            throw new IllegalArgumentException("insert() index " + index + " is past the end of this list");
        }
        int[] temp = new int[this.count + values.length];
        System.arraycopy(this.data, 0, temp, 0, Math.min(this.count, index));
        System.arraycopy(values, 0, temp, index, values.length);
        System.arraycopy(this.data, index, temp, index + values.length, this.count - index);
        this.count += values.length;
        this.data = temp;
    }

    public void insert(int index, IntList list) {
        this.insert(index, list.values());
    }

    public int index(int what) {
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != what) continue;
            return i;
        }
        return -1;
    }

    public boolean hasValue(int value) {
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != value) continue;
            return true;
        }
        return false;
    }

    public void increment(int index) {
        int n = index;
        this.data[n] = this.data[n] + 1;
    }

    public void add(int index, int amount) {
        int n = index;
        this.data[n] = this.data[n] + amount;
    }

    public void sub(int index, int amount) {
        int n = index;
        this.data[n] = this.data[n] - amount;
    }

    public void mult(int index, int amount) {
        int n = index;
        this.data[n] = this.data[n] * amount;
    }

    public void div(int index, int amount) {
        int n = index;
        this.data[n] = this.data[n] / amount;
    }

    private void checkMinMax(String functionName) {
        if (this.count == 0) {
            String msg = String.format("Cannot use %s() on an empty %s.", functionName, this.getClass().getSimpleName());
            throw new RuntimeException(msg);
        }
    }

    public int min() {
        this.checkMinMax("min");
        int outgoing = this.data[0];
        for (int i = 1; i < this.count; ++i) {
            if (this.data[i] >= outgoing) continue;
            outgoing = this.data[i];
        }
        return outgoing;
    }

    public int minIndex() {
        this.checkMinMax("minIndex");
        int value = this.data[0];
        int index = 0;
        for (int i = 1; i < this.count; ++i) {
            if (this.data[i] >= value) continue;
            value = this.data[i];
            index = i;
        }
        return index;
    }

    public int max() {
        this.checkMinMax("max");
        int outgoing = this.data[0];
        for (int i = 1; i < this.count; ++i) {
            if (this.data[i] <= outgoing) continue;
            outgoing = this.data[i];
        }
        return outgoing;
    }

    public int maxIndex() {
        this.checkMinMax("maxIndex");
        int value = this.data[0];
        int index = 0;
        for (int i = 1; i < this.count; ++i) {
            if (this.data[i] <= value) continue;
            value = this.data[i];
            index = i;
        }
        return index;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.count);
    }

    public void sortReverse() {
        new Sort(){

            @Override
            public int size() {
                return IntList.this.count;
            }

            @Override
            public float compare(int a, int b) {
                return IntList.this.data[b] - IntList.this.data[a];
            }

            @Override
            public void swap(int a, int b) {
                int temp = IntList.this.data[a];
                IntList.this.data[a] = IntList.this.data[b];
                IntList.this.data[b] = temp;
            }
        }.run();
    }

    public void reverse() {
        int ii = this.count - 1;
        for (int i = 0; i < this.count / 2; ++i) {
            int t = this.data[i];
            this.data[i] = this.data[ii];
            this.data[ii] = t;
            --ii;
        }
    }

    public void shuffle() {
        Random r = new Random();
        int num = this.count;
        while (num > 1) {
            int value = r.nextInt(num);
            int temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public void shuffle(PApplet sketch) {
        int num = this.count;
        while (num > 1) {
            int value = (int)sketch.random(num);
            int temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public IntList copy() {
        IntList outgoing = new IntList(this.data);
        outgoing.count = this.count;
        return outgoing;
    }

    public int[] values() {
        this.crop();
        return this.data;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int index = -1;

            @Override
            public void remove() {
                IntList.this.remove(this.index);
            }

            @Override
            public Integer next() {
                return IntList.this.data[++this.index];
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < IntList.this.count;
            }
        };
    }

    public int[] array() {
        return this.array(null);
    }

    public int[] array(int[] array) {
        if (array == null || array.length != this.count) {
            array = new int[this.count];
        }
        System.arraycopy(this.data, 0, array, 0, this.count);
        return array;
    }

    public IntList getSubset(int start) {
        return this.getSubset(start, this.count - start);
    }

    public IntList getSubset(int start, int num) {
        IntList outgoing = new IntList(num);
        for (int i = 0; i < num; ++i) {
            System.arraycopy(this.data, start, outgoing.data, 0, num);
        }
        return outgoing;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + " size=" + this.size() + " [ ");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(i + ": " + this.data[i]);
        }
        sb.append(" ]");
        return sb.toString();
    }
}

