#version 330

precision highp float;

uniform sampler2D previousState;
uniform float size[2];

smooth in vec2 vTexCoord;

out vec4 vColor;

void main()
{
    vColor = vec4(0.0,0.0,0.0,1.0);
	vec4 pre = texture(previousState, vTexCoord.st);
    vec4 nachbarn = vec4(0.0);
        for(int i = -1; i < 2; i++)
        {
            for(int j = -1; j < 2; j++)
            {
                if(i != 0 || j !=  0){
					nachbarn += texture(previousState,vec2(vTexCoord.s+(i*(1.0/size[0])),vTexCoord.t+(j*(1.0/size[1]))));
				}
            }
        }
        if(pre.g == 1.0)
			vColor = vec4(0.0, 0.0, 1.0, 1.0);
		if(pre.b == 1.0)
			vColor = vec4(1.0, 0.0, 0.0, 1.0);
		
		if(pre.r > 0.0) {
			if(nachbarn.g == 1.0 || nachbarn.g == 2.0)
				vColor = vec4(0.0,1.0,0.0,1.0);
			else
				vColor = vec4(1.0,0.0,0.0,1.0);
		}
}