#version 330

precision highp float;
layout (triangles) in;
layout (triangle_strip, max_vertices = 6) out;

uniform mat4 mvprMatrix;
uniform int renderImage;
uniform float TrackTime;

out vec4 vColor;

vec4 HSVAtoRGBA(vec4 HSVA);
float rand(vec2 co);

void main(void) {
	vec2 times = vec2(99971.364, 3843.386);//Aufteilung: Offset, Takt
	vec3 ab = gl_in[1].gl_Position.xyz - gl_in[0].gl_Position.xyz; // 0->1
	vec3 ac = gl_in[2].gl_Position.xyz - gl_in[0].gl_Position.xyz; // 0->2
	vec3 vNormal = normalize(cross(ab, ac));
	
	float vValue = 0.0;
	if(TrackTime < times.x+3.0*times.y)
		vValue = smoothstep(times.x+1.0*times.y,times.x+3.0*times.y,TrackTime)*0.55;
	else
		vValue = 0.55;

	vNormal = vNormal+vec3(1.0)*vec3(0.5);

	float stepper = smoothstep(0.4,0.5, rand(vNormal.xy)*rand(vNormal.yz));
	float firstC  = 0.094*stepper;
	float secC = 0.6139*(stepper*(-1.0)+1.0);

	vec4 myHSVA = vec4(firstC+secC, 0.0, (firstC+secC)*rand(vNormal.xy)*rand(vNormal.yz)*vValue, 1.0);
	if(TrackTime > times.x+5.0*times.y){
		myHSVA.g = 0.7;
		myHSVA.b = vValue;
	}
	if(TrackTime > times.x+7.0*times.y)
		myHSVA.b *= smoothstep(times.x+7.0*times.y,times.x+8.0*times.y, TrackTime)*(-1.0)+1.0;

	vColor = HSVAtoRGBA(myHSVA);

	for(int i = 0; i < 3; i++) {
		vec4 myVertex = gl_in[i].gl_Position;
		gl_Position = mvprMatrix*myVertex;
		EmitVertex();
	}
	EndPrimitive();
	

	if(TrackTime > times.x+5.0*times.y && TrackTime < times.x+8.0*times.y && renderImage != 1){
		myHSVA.g = 0.0;
		myHSVA.b = rand(vNormal.xy)*rand(vNormal.yz)*vValue;
		myHSVA.a = smoothstep(times.x+5.0*times.y, times.x+8.0*times.y, TrackTime)*(-1.0)+1.0;

		if(TrackTime > times.x+7.0*times.y)
			myHSVA.b *= smoothstep(times.x+7.0*times.y,times.x+8.0*times.y, TrackTime)*(-1.0)+1.0;

		vColor = HSVAtoRGBA(myHSVA);
		for(int i = 0; i < 3; i++) {
			vec4 myVertex = gl_in[i].gl_Position;
			myVertex += vec4(smoothstep(times.x+5.0*times.y, times.x+8.0*times.y, TrackTime)*1.0*vNormal, 0.0)*vec4(0.4, 0.4, 0.4, 1.0);
			myVertex.y += smoothstep(times.x+5.0*times.y, times.x+8.0*times.y, TrackTime)*15.0;
			myVertex.z -= smoothstep(times.x+5.0*times.y, times.x+8.0*times.y, TrackTime)*1.5;
			myVertex.y += sin(myVertex.y*0.5+(TrackTime/1000.0))*2.0;
			gl_Position = mvprMatrix*myVertex;
			EmitVertex();
		}
		EndPrimitive();
	}
	
}

float rand(vec2 co)
{
	return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec4 HSVAtoRGBA(vec4 HSVA)
{
	vec4 RGBAreturner;
	RGBAreturner.a = HSVA.w;
	HSVA.x *= 360.0;
	int hi = int((HSVA.x-mod(HSVA.x, 60.0))/60.0);
	float f = HSVA.x/60.0-hi;
	float p = HSVA.z*(1-HSVA.y);
	float q = HSVA.z*(1-HSVA.y*f);
	float t = HSVA.z*(1-HSVA.y*(1-f));
	
	switch(hi) {
	case 0:
	case 6:
		RGBAreturner.rgb = vec3(HSVA.z, t, p);
		break;
	case 1:
		RGBAreturner.rgb = vec3(q, HSVA.z, p);
		break;
	case 2:
		RGBAreturner.rgb = vec3(p, HSVA.z, t);
		break;
	case 3:
		RGBAreturner.rgb = vec3(p, q, HSVA.z);
		break;
	case 4:
		RGBAreturner.rgb = vec3(t, p, HSVA.z);
		break;
	case 5:
		RGBAreturner.rgb = vec3(HSVA.z, p, q);
		break;
	default:
		RGBAreturner.rgb = vec3(0.0);
		break;
	}
	return RGBAreturner;
}