#version 330

precision highp float;

uniform mat4 mvprMatrix;
uniform sampler2D HeightMap;

in vec4 vVertex;
in vec2 vTexCoords;

smooth out vec2 vTexCoord;
flat out vec4 PositionValues;//Aufteilung: x1,z1, texResultHeight, Height1
flat out vec4 randRahmen;
out float onTop;

float rand(vec2 co);

void main(void)
{
	vec2 size = vec2(64.0,64.0);
	float Height1 = 10.0;
	float x1 = mod(gl_InstanceID, size.x);//x[0,size.x]
	float z1 = (gl_InstanceID-x1)/size.y;//z[0,size.y]

	float texResultHeight = texture(HeightMap, vec2(x1/size.x, z1/size.y)).r;

	float HeightVal = 0.0;
	if(vVertex.y > 0.0) {
		HeightVal = texResultHeight;
		onTop = 1.0;
	}
	else
		onTop = 0.0;
	vec4 myVertex = vec4(vVertex.x+((x1-size.x/2.0)+0.5)*4.0, (vVertex.y*HeightVal*Height1), vVertex.z+((z1-size.y/2.0)+0.5)*4.0, vVertex.w);
	
	vTexCoord.st = vTexCoords.st;
	PositionValues = vec4(x1,z1, texResultHeight, Height1);

	randRahmen = vec4(0.053,0.102,0.349,1.0);
	
	gl_Position = mvprMatrix*myVertex;
}

float rand(vec2 co)
{
	return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}