#version 330

precision highp float;

smooth in vec2 vTexCoord;

out vec4 Color;

float rand(vec2 co)
{
	return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main(void)
{
	float pureRand = rand(vTexCoord);
	float dist = 0.15/distance(vec2(0.5), vTexCoord);
	if(dist > 1.0)
		dist = 1.0;
	float mixedColor = dist*pureRand;
	if(rand(vTexCoord.st) > 0.8 && rand(vTexCoord.ts) > 0.99)
		mixedColor = 0.75;
	
	mixedColor = clamp(mixedColor, 0.0, 1.0);
	mixedColor -= mod(mixedColor, 0.05);
	mixedColor = max(mixedColor, 0.05);
	Color = vec4(vec3(mixedColor), 1.0);
}