struct MATERIAL{vec3 specular;vec3 emission;float transparency;int numTextures;int useLights;vec2 offset_animacion0;vec2 offset_animacion1;};struct LIGHT{vec3 diffuse;float attenuation_start;vec3 position;float attenuation_end;vec3 direction;float hotspot_beam;float falloff;int type;};struct LightModelParameters{vec3 ambient;};uniform mat4 NormalMatrix;uniform mat4 ModelViewProjectionMatrix;uniform mat4 WorldMatrix;uniform mat4 ProjectionMatrix;uniform vec3 posicion_camara_world;uniform LIGHT g_Lights[MAX_LIGHTS];uniform LightModelParameters g_LightModel;uniform MATERIAL g_DatosMaterial;uniform sampler2D shader_texture_ids[NUMERO_MAXIMO_TEXTURAS_POR_MATERIAL];varying vec4  color_final_BLUR;varying vec2 text_coord[NUMERO_MAXIMO_TEXTURAS_POR_MATERIAL];varying vec3 light_final_intensity;varying vec3 light_final_specular;
#define at_VertexCoords           gl_Vertex
#define at_Normal                 gl_Normal
#define at_MultiTexCoord0         gl_MultiTexCoord0
#define at_MultiTexCoord1         gl_MultiTexCoord1
attribute highp vec4 joint_weights ;attribute highp vec4 joint_indices ;void ProcesarIluminacion(vec4 vertice, vec3 normal){  highp vec3 emi = g_DatosMaterial.emission ;  highp float invEmi = min( (1.0-(length(emi)*0.25)), 1.0) ;  if ( invEmi > 0.0 ) {    highp vec3 diffuse_acumulado = vec3(0.0, 0.0, 0.0) ;    highp vec3 specular_acumulado = vec3(0.0, 0.0, 0.0) ;    highp vec3 light_normal = normalize(normal) ;    highp vec3 spe = g_DatosMaterial.specular ;    highp float speVal = length(spe) ;    highp vec3 posicion_camara = posicion_camara_world ;    highp vec3 normalized_vertex_to_camera = vec3(0.0, 0.0, 0.0) ;    if(speVal > 0.0) {      normalized_vertex_to_camera = normalize(posicion_camara - vertice.xyz) ;    }    for(int var_luz = 0; var_luz < MAX_LIGHTS; var_luz++) {      lowp int lightType = g_Lights[var_luz].type ;      if(lightType == LIGHT_TYPE_NONE) {      }      else {        highp float light_intensity ;        highp vec3 normalized_vertex_to_light ;        highp float normal_dot_light_vector ;        if(lightType == LIGHT_TYPE_SPOT) {          highp vec3 vertex_to_light = g_Lights[var_luz].position - vertice.xyz ;          normalized_vertex_to_light = normalize(vertex_to_light) ;          normal_dot_light_vector = dot(light_normal, normalized_vertex_to_light) ;          if(normal_dot_light_vector <= 0.0) continue ;          const highp float baseConeAngle = 180.0 ;          highp float angle = baseConeAngle - (dot(g_Lights[var_luz].direction, normalized_vertex_to_light) * baseConeAngle) ;          light_intensity = smoothstep(g_Lights[var_luz].falloff, g_Lights[var_luz].hotspot_beam, angle) ;        }        else if(lightType == LIGHT_TYPE_POINT) {          highp vec3 vertex_to_light = g_Lights[var_luz].position - vertice.xyz ;          normalized_vertex_to_light = normalize(vertex_to_light) ;          normal_dot_light_vector = dot(light_normal, normalized_vertex_to_light) ;          if(normal_dot_light_vector <= 0.0) continue ;          highp float lightDist = length(vertex_to_light);          light_intensity = smoothstep(g_Lights[var_luz].attenuation_end, g_Lights[var_luz].attenuation_start, lightDist);        }         else {          normalized_vertex_to_light = g_Lights[var_luz].direction ;          normal_dot_light_vector = dot(light_normal, normalized_vertex_to_light) ;          if(normal_dot_light_vector <= 0.0) continue ;          light_intensity = 1.0 ;        }        if(light_intensity <= 0.0) continue ;        {          highp vec3 lightColor = g_Lights[var_luz].diffuse.rgb * light_intensity ;		  diffuse_acumulado += lightColor * normal_dot_light_vector ;        }      }    }    light_final_intensity = ((diffuse_acumulado + g_LightModel.ambient + specular_acumulado) * invEmi) + emi ;    light_final_specular = specular_acumulado * (invEmi*0.5) ;  }  else {    light_final_intensity = emi ;    light_final_specular = vec3(0.0, 0.0, 0.0) ;  }}void ProcesarTexturas(){  text_coord[0] = vec2(at_MultiTexCoord0) + g_DatosMaterial.offset_animacion0 ;}


// ------------------------------------------------------------------------------------------------
//
//
void main()
{
  /*if ( g_DatosMaterial.useLights == 0 ) {

    light_final_intensity = vec3(1.0, 1.0, 1.0) ;//g_DatosMaterial.emission ;
    light_final_specular = vec3(0.0, 0.0, 0.0) ;
  }
  else {*/
    vec4 vertice_a_iluminar = WorldMatrix * at_VertexCoords ;
    vec3 normal_a_iluminar = mat3(NormalMatrix) * at_Normal ;
    ProcesarIluminacion(vertice_a_iluminar, normal_a_iluminar) ;
  //}

  ProcesarTexturas() ;

  gl_Position = ModelViewProjectionMatrix * at_VertexCoords ;
}

