;rework off book "Machine Code Sprite & Graphics For The ZX Spectrum
;page 107   'Drum Scroll Right to Left'
; triple  2/3 screen  scroll, 3 x 4096 bytes , no attr

px1	equ	24100		; normal adres 2nd scr
px1h	equ	px1+4095	; highest adres 2nd scr
px2	equ	px1h+1		; normal adres 2nd scr
px2h	equ	px2+4095	; highest adres 2nd scr

sc	equ	16384
sch	equ	sc+4095
len	equ	px2h-sc

seed	equ	23670		;  used as temp counter

mc	equ	23296		;  start MC on
	org	mc		;   >> 23296 printerbuffer (max 256 bytes)

r2l	ld	bc,$0002
round	push	bc

	ld	hl,px2h		; px high adress (end)
pk01	equ	$-2

	ld	(seed),hl

pk02	equ	$+1
	ld	hl,sch
	ld	de,px1h
	push	af
	ld	c,128		;  2/3 screen

nxtl	pop	af		;  dump stack in AF to clear stack
	push	hl		;  1 byte before right border 
	xor	a

	ld	b,$20		;  32 bytes wide
nxthl	ld	a,(hl)
pk03	rla
	ld	(hl),a
pk04	dec	hl
	djnz	nxthl
	push	hl		;  last screen byte, left side

	ld	b,$20		;|
nxtde	ld	a,(de)		;||
pk06	rla			;||
	ld	(de),a		;||
pk07	dec	de		;||
	djnz	nxtde		;||

	ld	hl,(seed)
	ld	b,$20		; 32 bytes wide
nxthl3	ld	a,(hl)
pk08	rla
	ld	(hl),a
pk09	dec	hl
	djnz	nxthl3
	ld	(seed),hl

	pop	hl		;  screen adress
	ex	(sp),hl
	ld	a,0		; keep CARRY-flag
pk10	rla
	or	(hl)
	ld	(hl),a
	ex	(sp),hl
	pop	af
	push	af
	dec	c
	jr	nz,nxtl
	pop	af		; clear screen-stack

	pop	bc
	djnz	round
	dec	c
	jr	nz,round	; 3 screens = 3x 256 bytes

l2r	ld	bc,$0002
rond	push	bc
	ld	hl,px2
	ld	(seed),hl
	ld	hl,sc
	ld	de,px1
	push	af
	ld	c,128		;  2/3 screen

nxt_l	pop	af		;  dump stack in AF to clear stack
	push	hl		;  1 byte before right border 
	xor	a

	ld	b,$20		;  32 bytes wide
nxt_hl	ld	a,(hl)
	rra
	ld	(hl),a
	inc	hl
	djnz	nxt_hl
	push	hl		;  last screen byte, left side

	ld	hl,(seed)
	ld	b,$20		; 32 bytes wide
nxt_hl3	ld	a,(hl)
	rra
	ld	(hl),a
	inc	hl
	djnz	nxt_hl3
	ld	(seed),hl

	ld	b,$20		;|
nxt_de	ld	a,(de)		;||
	rra			;||
	ld	(de),a		;||
	inc	de		;||
	djnz	nxt_de		;||


	pop	hl		;  screen adress
	ex	(sp),hl
	ld	a,0		; keep CARRY-flag
	rra
	or	(hl)
	ld	(hl),a
	ex	(sp),hl
	pop	af
	push	af
	dec	c
	jr	nz,nxt_l
	pop	af		; clear screen-stack

	pop	bc
	djnz	rond
	dec	c
	jr	nz,rond	; 3 screens = 3x 256 bytes

	jp	r2l		;  END LESS SCROLL WITHOUT BREAK

