/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import jogamp.common.Debug;
import jogamp.common.os.elf.ElfHeader;
import jogamp.common.os.elf.SectionArmAttributes;
import jogamp.common.os.elf.SectionHeader;

public abstract class PlatformPropsImpl {
    static final boolean DEBUG = Debug.debug("Platform");
    public static final VersionNumber Version16 = new VersionNumber(1, 6, 0);
    public static final String OS = System.getProperty("os.name");
    public static final String OS_lower = OS.toLowerCase();
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final VersionNumber OS_VERSION_NUMBER = new VersionNumber(OS_VERSION, ".");
    public static final String ARCH = System.getProperty("os.arch");
    public static final String ARCH_lower = ARCH.toLowerCase();
    public static final String JAVA_VENDOR = System.getProperty("java.vendor");
    public static final String JAVA_VENDOR_URL = System.getProperty("java.vendor.url");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final VersionNumber JAVA_VERSION_NUMBER = new VersionNumber(JAVA_VERSION, ".");
    public static final String JAVA_VM_NAME = System.getProperty("java.vm.name");
    public static final String JAVA_RUNTIME_NAME = PlatformPropsImpl.getJavaRuntimeNameImpl();
    public static final boolean JAVA_SE = PlatformPropsImpl.initIsJavaSE();
    public static final boolean JAVA_6 = JAVA_SE && (AndroidVersion.isAvailable || JAVA_VERSION_NUMBER.compareTo(Version16) >= 0);
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final boolean LITTLE_ENDIAN = PlatformPropsImpl.queryIsLittleEndianImpl();
    public static final Platform.CPUType CPU_ARCH = PlatformPropsImpl.getCPUTypeImpl(ARCH_lower);
    public static final Platform.ABIType ABI_TYPE;
    public static final Platform.OSType OS_TYPE;
    public static final String os_and_arch;

    protected PlatformPropsImpl() {
    }

    private static final String getJavaRuntimeNameImpl() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.runtime.name");
            }
        });
    }

    private static final boolean initIsJavaSE() {
        if (null != JAVA_RUNTIME_NAME && JAVA_RUNTIME_NAME.indexOf("Java SE") != -1) {
            return true;
        }
        try {
            Class.forName("java.nio.LongBuffer");
            Class.forName("java.nio.DoubleBuffer");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static final boolean queryIsLittleEndianImpl() {
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(4);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        intBuffer.put(0, 168496141);
        return 3085 == shortBuffer.get(0);
    }

    private static final Platform.CPUType getCPUTypeImpl(String string) {
        if (string.equals("x86") || string.equals("i386") || string.equals("i486") || string.equals("i586") || string.equals("i686")) {
            return Platform.CPUType.X86_32;
        }
        if (string.equals("x86_64") || string.equals("amd64")) {
            return Platform.CPUType.X86_64;
        }
        if (string.equals("ia64")) {
            return Platform.CPUType.IA64;
        }
        if (string.equals("arm")) {
            return Platform.CPUType.ARM;
        }
        if (string.equals("armv5l")) {
            return Platform.CPUType.ARMv5;
        }
        if (string.equals("armv6l")) {
            return Platform.CPUType.ARMv6;
        }
        if (string.equals("armv7l")) {
            return Platform.CPUType.ARMv7;
        }
        if (string.equals("sparc")) {
            return Platform.CPUType.SPARC_32;
        }
        if (string.equals("sparcv9")) {
            return Platform.CPUType.SPARCV9_64;
        }
        if (string.equals("pa_risc2.0")) {
            return Platform.CPUType.PA_RISC2_0;
        }
        if (string.equals("ppc")) {
            return Platform.CPUType.PPC;
        }
        throw new RuntimeException("Please port CPU detection to your platform (" + OS_lower + "/" + string + ")");
    }

    private static final boolean contains(String string, String[] stringArray) {
        if (null != string && null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static final Platform.ABIType queryABITypeImpl(final Platform.OSType oSType, Platform.CPUType cPUType) {
        if (Platform.CPUFamily.ARM != cPUType.family) {
            return Platform.ABIType.GENERIC_ABI;
        }
        if (Platform.OSType.ANDROID == oSType) {
            return Platform.ABIType.EABI_GNU_ARMEL;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Platform.ABIType>(){
            private final String GNU_LINUX_SELF_EXE = "/proc/self/exe";

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Platform.ABIType run() {
                Object object;
                boolean bl = false;
                boolean bl2 = false;
                RandomAccessFile randomAccessFile = null;
                try {
                    object = null;
                    if (Platform.OSType.LINUX == oSType && !PlatformPropsImpl.checkFileReadAccess(object = new File("/proc/self/exe"))) {
                        object = null;
                    }
                    if (null == object) {
                        object = PlatformPropsImpl.findSysLib("java");
                    }
                    if (null == object) {
                        object = PlatformPropsImpl.findSysLib("jvm");
                    }
                    if (null != object) {
                        SectionHeader sectionHeader;
                        randomAccessFile = new RandomAccessFile((File)object, "r");
                        ElfHeader elfHeader = ElfHeader.read(randomAccessFile);
                        if (DEBUG) {
                            System.err.println("ELF: Got HDR /proc/self/exe: " + elfHeader);
                        }
                        if ((bl = elfHeader.isArm()) && null != (sectionHeader = elfHeader.getSectionHeader(0x70000003))) {
                            SectionArmAttributes.Attribute attribute;
                            if (DEBUG) {
                                System.err.println("ELF: Got ARM Attribs Section Header: " + sectionHeader);
                            }
                            SectionArmAttributes sectionArmAttributes = (SectionArmAttributes)sectionHeader.readSection(randomAccessFile);
                            if (DEBUG) {
                                System.err.println("ELF: Got ARM Attribs Section Block : " + sectionArmAttributes);
                            }
                            if (null != (attribute = sectionArmAttributes.get(SectionArmAttributes.Tag.ABI_VFP_args))) {
                                bl2 = SectionArmAttributes.abiVFPArgsAcceptsVFPVariant(attribute.getULEB128());
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (DEBUG) {
                        throwable.printStackTrace();
                    }
                }
                finally {
                    if (null != randomAccessFile) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                object = bl ? (bl2 ? Platform.ABIType.EABI_GNU_ARMHF : Platform.ABIType.EABI_GNU_ARMEL) : Platform.ABIType.GENERIC_ABI;
                if (DEBUG) {
                    System.err.println("ELF: abiARM " + bl + ", abiVFPArgsAcceptsVFPVariant " + bl2 + " -> " + object);
                }
                return object;
            }
        });
    }

    private static boolean checkFileReadAccess(File file) {
        try {
            return file.isFile() && file.canRead();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static File findSysLib(String string) {
        ClassLoader classLoader = PlatformPropsImpl.class.getClassLoader();
        List<String> list = NativeLibrary.enumerateLibraryPaths(string, string, string, true, classLoader);
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            File file = new File(string2);
            if (DEBUG) {
                System.err.println("findSysLib #" + i + ": test " + file);
            }
            if (PlatformPropsImpl.checkFileReadAccess(file)) {
                return file;
            }
            if (!DEBUG) continue;
            System.err.println("findSysLib #" + i + ": " + file + " not readable");
        }
        return null;
    }

    private static final Platform.OSType getOSTypeImpl() throws RuntimeException {
        if (AndroidVersion.isAvailable) {
            return Platform.OSType.ANDROID;
        }
        if (OS_lower.startsWith("linux")) {
            return Platform.OSType.LINUX;
        }
        if (OS_lower.startsWith("freebsd")) {
            return Platform.OSType.FREEBSD;
        }
        if (OS_lower.startsWith("android")) {
            return Platform.OSType.ANDROID;
        }
        if (OS_lower.startsWith("mac os x") || OS_lower.startsWith("darwin")) {
            return Platform.OSType.MACOS;
        }
        if (OS_lower.startsWith("sunos")) {
            return Platform.OSType.SUNOS;
        }
        if (OS_lower.startsWith("hp-ux")) {
            return Platform.OSType.HPUX;
        }
        if (OS_lower.startsWith("windows")) {
            return Platform.OSType.WINDOWS;
        }
        if (OS_lower.startsWith("kd")) {
            return Platform.OSType.OPENKODE;
        }
        throw new RuntimeException("Please port OS detection to your platform (" + OS_lower + "/" + ARCH_lower + ")");
    }

    public static void initSingleton() {
    }

    public static final String getOSAndArch(Platform.OSType oSType, Platform.CPUType cPUType, Platform.ABIType aBIType) {
        String string;
        switch (cPUType) {
            case X86_32: {
                string = "i586";
                break;
            }
            case ARM: 
            case ARMv5: 
            case ARMv6: 
            case ARMv7: {
                string = "armv6";
                break;
            }
            case SPARC_32: {
                string = "sparc";
                break;
            }
            case PPC: {
                string = "ppc";
                break;
            }
            case X86_64: {
                string = "amd64";
                break;
            }
            case IA64: {
                string = "ia64";
                break;
            }
            case SPARCV9_64: {
                string = "sparcv9";
                break;
            }
            case PA_RISC2_0: {
                string = "risc2.0";
                break;
            }
            default: {
                throw new InternalError("Complete case block");
            }
        }
        if (Platform.ABIType.EABI_GNU_ARMHF == aBIType) {
            string = string + "hf";
        }
        switch (oSType) {
            case ANDROID: {
                string = "android-" + string;
                break;
            }
            case MACOS: {
                string = "macosx-universal";
                break;
            }
            case WINDOWS: {
                string = "windows-" + string;
                break;
            }
            case OPENKODE: {
                string = "openkode-" + string;
                break;
            }
            case LINUX: {
                string = "linux-" + string;
                break;
            }
            case FREEBSD: {
                string = "freebsd-" + string;
                break;
            }
            case SUNOS: {
                string = "solaris-" + string;
                break;
            }
            case HPUX: {
                string = "hpux-hppa";
                break;
            }
            default: {
                throw new InternalError("Complete case block");
            }
        }
        return string;
    }

    static {
        OS_TYPE = PlatformPropsImpl.getOSTypeImpl();
        ABI_TYPE = PlatformPropsImpl.queryABITypeImpl(OS_TYPE, CPU_ARCH);
        os_and_arch = PlatformPropsImpl.getOSAndArch(OS_TYPE, CPU_ARCH, ABI_TYPE);
    }
}

