/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.locks.RecursiveLock;
import java.io.PrintStream;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.WindowClosingProtocol;
import javax.media.opengl.FPSCounter;
import javax.media.opengl.GL;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import jogamp.opengl.FPSCounterImpl;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableHelper;
import jogamp.opengl.GLDrawableImpl;

public abstract class GLAutoDrawableBase
implements GLAutoDrawable,
FPSCounter {
    public static final boolean DEBUG = GLDrawableImpl.DEBUG;
    protected final GLDrawableHelper helper = new GLDrawableHelper();
    protected final FPSCounterImpl fpsCounter = new FPSCounterImpl();
    protected volatile GLDrawableImpl drawable;
    protected GLContextImpl context;
    protected final boolean ownsDevice;
    protected int additionalCtxCreationFlags = 0;
    protected volatile boolean sendReshape = false;
    protected volatile boolean sendDestroy = false;
    protected final Runnable defaultInitAction = new Runnable(){

        @Override
        public final void run() {
            GLAutoDrawableBase.this.helper.init(GLAutoDrawableBase.this, !GLAutoDrawableBase.this.sendReshape);
            GLAutoDrawableBase.this.resetFPSCounter();
        }
    };
    protected final Runnable defaultDisplayAction = new Runnable(){

        @Override
        public final void run() {
            if (GLAutoDrawableBase.this.sendReshape) {
                GLAutoDrawableBase.this.helper.reshape(GLAutoDrawableBase.this, 0, 0, GLAutoDrawableBase.this.getWidth(), GLAutoDrawableBase.this.getHeight());
                GLAutoDrawableBase.this.sendReshape = false;
            }
            GLAutoDrawableBase.this.helper.display(GLAutoDrawableBase.this);
            GLAutoDrawableBase.this.fpsCounter.tickFPS();
        }
    };

    public GLAutoDrawableBase(GLDrawableImpl gLDrawableImpl, GLContextImpl gLContextImpl, boolean bl) {
        this.drawable = gLDrawableImpl;
        this.context = gLContextImpl;
        this.ownsDevice = bl;
        if (null != gLContextImpl && null != gLDrawableImpl) {
            gLContextImpl.setGLDrawable(gLDrawableImpl, false);
        }
        this.resetFPSCounter();
    }

    protected abstract RecursiveLock getLock();

    protected final void defaultWindowRepaintOp() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        if (null != gLDrawableImpl && gLDrawableImpl.isRealized() && !gLDrawableImpl.getNativeSurface().isSurfaceLockedByOtherThread() && !this.helper.isAnimatorAnimatingOnOtherThread()) {
            this.display();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void defaultWindowResizedOp(int n, int n2) throws NativeWindowException, GLException {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        if (null != gLDrawableImpl) {
            if (DEBUG) {
                System.err.println("GLAutoDrawableBase.sizeChanged: (" + Thread.currentThread().getName() + "): " + n + "x" + n2 + " - surfaceHandle 0x" + Long.toHexString(this.getNativeSurface().getSurfaceHandle()));
            }
            if (!gLDrawableImpl.getChosenGLCapabilities().isOnscreen()) {
                RecursiveLock recursiveLock = this.getLock();
                recursiveLock.lock();
                try {
                    GLDrawableImpl gLDrawableImpl2 = GLDrawableHelper.resizeOffscreenDrawable(gLDrawableImpl, this.context, n, n2);
                    if (gLDrawableImpl != gLDrawableImpl2) {
                        gLDrawableImpl = gLDrawableImpl2;
                        this.drawable = gLDrawableImpl2;
                    }
                }
                finally {
                    recursiveLock.unlock();
                }
            }
            this.sendReshape = true;
            if (gLDrawableImpl.isRealized() && !gLDrawableImpl.getNativeSurface().isSurfaceLockedByOtherThread() && !this.helper.isAnimatorAnimatingOnOtherThread()) {
                this.display();
            }
        }
    }

    protected final void defaultWindowDestroyNotifyOp() {
        NativeSurface nativeSurface = this.getNativeSurface();
        boolean bl = nativeSurface instanceof WindowClosingProtocol ? WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE == ((WindowClosingProtocol)((Object)nativeSurface)).getDefaultCloseOperation() : true;
        if (bl) {
            this.destroyAvoidAwareOfLocking();
        }
    }

    protected final void destroyAvoidAwareOfLocking() {
        NativeSurface nativeSurface = this.getNativeSurface();
        GLAnimatorControl gLAnimatorControl = this.helper.getAnimator();
        if (this.helper.isAnimatorStartedOnOtherThread()) {
            boolean bl = gLAnimatorControl.pause();
            this.destroy();
            if (bl) {
                gLAnimatorControl.resume();
            }
        } else if (null != nativeSurface && nativeSurface.isSurfaceLockedByOtherThread()) {
            this.sendDestroy = true;
        } else {
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void defaultDestroy() {
        RecursiveLock recursiveLock = this.getLock();
        recursiveLock.lock();
        try {
            this.destroyImplInLock();
        }
        finally {
            recursiveLock.unlock();
        }
    }

    protected void destroyImplInLock() {
        if (null != this.context) {
            if (this.context.isCreated()) {
                try {
                    this.helper.disposeGL(this, this.context, true);
                }
                catch (GLException gLException) {
                    gLException.printStackTrace();
                }
            }
            this.context = null;
        }
        if (null != this.drawable) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.drawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
            this.drawable.setRealized(false);
            this.drawable = null;
            if (this.ownsDevice) {
                abstractGraphicsDevice.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void defaultSwapBuffers() throws GLException {
        RecursiveLock recursiveLock = this.getLock();
        recursiveLock.lock();
        try {
            if (null != this.drawable) {
                this.drawable.swapBuffers();
            }
        }
        finally {
            recursiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void defaultDisplay() {
        if (this.sendDestroy) {
            this.sendDestroy = false;
            this.destroy();
            return;
        }
        RecursiveLock recursiveLock = this.getLock();
        recursiveLock.lock();
        try {
            if (null != this.context) {
                this.helper.invokeGL(this.drawable, this.context, this.defaultDisplayAction, this.defaultInitAction);
            }
        }
        finally {
            recursiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final GLEventListener defaultDisposeGLEventListener(GLEventListener gLEventListener, boolean bl) {
        RecursiveLock recursiveLock = this.getLock();
        recursiveLock.lock();
        try {
            GLEventListener gLEventListener2 = this.helper.disposeGLEventListener(this, this.drawable, this.context, gLEventListener, bl);
            return gLEventListener2;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final GLDrawable getDelegatedDrawable() {
        return this.drawable;
    }

    @Override
    public final GLContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLContext setContext(GLContext gLContext) {
        RecursiveLock recursiveLock = this.getLock();
        recursiveLock.lock();
        try {
            GLContextImpl gLContextImpl = this.context;
            boolean bl = GLDrawableHelper.switchContext(this.drawable, gLContextImpl, gLContext, this.additionalCtxCreationFlags);
            this.context = (GLContextImpl)gLContext;
            if (bl) {
                this.context.makeCurrent();
            }
            GLContextImpl gLContextImpl2 = gLContextImpl;
            return gLContextImpl2;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final GL getGL() {
        GLContextImpl gLContextImpl = this.context;
        if (gLContextImpl == null) {
            return null;
        }
        return ((GLContext)gLContextImpl).getGL();
    }

    @Override
    public final GL setGL(GL gL) {
        GLContextImpl gLContextImpl = this.context;
        if (gLContextImpl != null) {
            ((GLContext)gLContextImpl).setGL(gL);
            return gL;
        }
        return null;
    }

    @Override
    public final void addGLEventListener(GLEventListener gLEventListener) {
        this.helper.addGLEventListener(gLEventListener);
    }

    @Override
    public final void addGLEventListener(int n, GLEventListener gLEventListener) throws IndexOutOfBoundsException {
        this.helper.addGLEventListener(n, gLEventListener);
    }

    @Override
    public int getGLEventListenerCount() {
        return this.helper.getGLEventListenerCount();
    }

    @Override
    public GLEventListener getGLEventListener(int n) throws IndexOutOfBoundsException {
        return this.helper.getGLEventListener(n);
    }

    @Override
    public boolean getGLEventListenerInitState(GLEventListener gLEventListener) {
        return this.helper.getGLEventListenerInitState(gLEventListener);
    }

    @Override
    public void setGLEventListenerInitState(GLEventListener gLEventListener, boolean bl) {
        this.helper.setGLEventListenerInitState(gLEventListener, bl);
    }

    @Override
    public GLEventListener disposeGLEventListener(GLEventListener gLEventListener, boolean bl) {
        return this.defaultDisposeGLEventListener(gLEventListener, bl);
    }

    @Override
    public final GLEventListener removeGLEventListener(GLEventListener gLEventListener) {
        return this.helper.removeGLEventListener(gLEventListener);
    }

    @Override
    public final void setAnimator(GLAnimatorControl gLAnimatorControl) throws GLException {
        this.helper.setAnimator(gLAnimatorControl);
    }

    @Override
    public final GLAnimatorControl getAnimator() {
        return this.helper.getAnimator();
    }

    @Override
    public final Thread setExclusiveContextThread(Thread thread) throws GLException {
        return this.helper.setExclusiveContextThread(thread, this.context);
    }

    @Override
    public final Thread getExclusiveContextThread() {
        return this.helper.getExclusiveContextThread();
    }

    @Override
    public final boolean invoke(boolean bl, GLRunnable gLRunnable) {
        return this.helper.invoke((GLAutoDrawable)this, bl, gLRunnable);
    }

    @Override
    public boolean invoke(boolean bl, List<GLRunnable> list) {
        return this.helper.invoke((GLAutoDrawable)this, bl, list);
    }

    @Override
    public final void setAutoSwapBufferMode(boolean bl) {
        this.helper.setAutoSwapBufferMode(bl);
    }

    @Override
    public final boolean getAutoSwapBufferMode() {
        return this.helper.getAutoSwapBufferMode();
    }

    @Override
    public final void setContextCreationFlags(int n) {
        this.additionalCtxCreationFlags = n;
        GLContextImpl gLContextImpl = this.context;
        if (null != gLContextImpl) {
            ((GLContext)gLContextImpl).setContextCreationFlags(this.additionalCtxCreationFlags);
        }
    }

    @Override
    public final int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public final void setUpdateFPSFrames(int n, PrintStream printStream) {
        this.fpsCounter.setUpdateFPSFrames(n, printStream);
    }

    @Override
    public final void resetFPSCounter() {
        this.fpsCounter.resetFPSCounter();
    }

    @Override
    public final int getUpdateFPSFrames() {
        return this.fpsCounter.getUpdateFPSFrames();
    }

    @Override
    public final long getFPSStartTime() {
        return this.fpsCounter.getFPSStartTime();
    }

    @Override
    public final long getLastFPSUpdateTime() {
        return this.fpsCounter.getLastFPSUpdateTime();
    }

    @Override
    public final long getLastFPSPeriod() {
        return this.fpsCounter.getLastFPSPeriod();
    }

    @Override
    public final float getLastFPS() {
        return this.fpsCounter.getLastFPS();
    }

    @Override
    public final int getTotalFPSFrames() {
        return this.fpsCounter.getTotalFPSFrames();
    }

    @Override
    public final long getTotalFPSDuration() {
        return this.fpsCounter.getTotalFPSDuration();
    }

    @Override
    public final float getTotalFPS() {
        return this.fpsCounter.getTotalFPS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLContext createContext(GLContext gLContext) {
        RecursiveLock recursiveLock = this.getLock();
        recursiveLock.lock();
        try {
            if (this.drawable != null) {
                GLContext gLContext2 = this.drawable.createContext(gLContext);
                gLContext2.setContextCreationFlags(this.additionalCtxCreationFlags);
                GLContext gLContext3 = gLContext2;
                return gLContext3;
            }
            GLContext gLContext4 = null;
            return gLContext4;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final boolean isRealized() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.isRealized() : false;
    }

    @Override
    public int getWidth() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getWidth() : 0;
    }

    @Override
    public int getHeight() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getHeight() : 0;
    }

    @Override
    public final GLCapabilitiesImmutable getChosenGLCapabilities() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getChosenGLCapabilities() : null;
    }

    @Override
    public final GLProfile getGLProfile() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getGLProfile() : null;
    }

    @Override
    public final NativeSurface getNativeSurface() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getNativeSurface() : null;
    }

    @Override
    public final long getHandle() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getHandle() : 0L;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ \n\tHelper: " + this.helper + ", \n\tDrawable: " + this.drawable + ", \n\tContext: " + this.context + "]";
    }
}

