/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioEffect;
import ddf.minim.AudioListener;
import ddf.minim.AudioMetaData;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.javasound.FloatSampleBuffer;
import ddf.minim.javasound.JSMinim;
import ddf.minim.spi.AudioRecordingStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Control;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.share.sampled.AudioUtils;

abstract class JSBaseAudioRecordingStream
implements Runnable,
AudioRecordingStream {
    private Thread iothread;
    private AudioListener listener;
    private AudioEffect effect;
    private AudioMetaData meta;
    private boolean play;
    private boolean loop;
    private int numLoops;
    private int loopBegin;
    private int loopEnd;
    protected AudioInputStream ais;
    private byte[] rawBytes;
    private byte[] skipBytes;
    private boolean shouldRead;
    private int totalBytesRead;
    private int bytesWritten;
    protected AudioFormat format;
    private SourceDataLine line;
    private FloatSampleBuffer buffer;
    private int bufferSize;
    private boolean finished;
    private float[] silence;
    protected JSMinim system;

    JSBaseAudioRecordingStream(JSMinim jSMinim, AudioMetaData audioMetaData, AudioInputStream audioInputStream, SourceDataLine sourceDataLine, int n, int n2) {
        this.system = jSMinim;
        this.meta = audioMetaData;
        this.format = sourceDataLine.getFormat();
        this.bufferSize = n;
        this.buffer = new FloatSampleBuffer(this.format.getChannels(), this.bufferSize, this.format.getSampleRate());
        this.system.debug("JSBaseAudioRecordingStream :: FloatSampleBuffer has " + this.buffer.getSampleCount() + " samples.");
        this.rawBytes = new byte[this.buffer.getByteArrayBufferSize(this.format)];
        this.system.debug("JSBaseAudioRecordingStream :: rawBytes has length " + this.rawBytes.length);
        this.skipBytes = new byte[(int)AudioUtils.millis2BytesFrameAligned((long)10000L, (AudioFormat)this.format)];
        this.system.debug("JSBaseAudioRecordingStream :: skipBytes has length " + this.skipBytes.length);
        this.finished = false;
        this.line = sourceDataLine;
        this.ais = audioInputStream;
        this.loop = false;
        this.play = false;
        this.numLoops = 0;
        this.loopBegin = 0;
        this.loopEnd = (int)AudioUtils.millis2BytesFrameAligned((long)n2, (AudioFormat)this.format);
        this.silence = new float[this.bufferSize];
        this.iothread = null;
        this.totalBytesRead = 0;
        this.bytesWritten = 0;
        this.shouldRead = true;
    }

    public AudioMetaData getMetaData() {
        return this.meta;
    }

    public int getMillisecondLength() {
        return this.meta.length();
    }

    @Override
    public void run() {
        while (!this.finished) {
            if (this.play) {
                if (this.shouldRead) {
                    if (this.loop) {
                        this.readBytesLoop();
                    } else {
                        this.readBytes();
                    }
                    this.process();
                }
                this.writeBytes();
                this.broadcast();
                Thread.yield();
                continue;
            }
            this.system.debug("Gonna wait...");
            this.broadcast();
            this.sleep(30000);
            this.system.debug("Done waiting!");
        }
        this.line.flush();
        this.line.close();
        this.line = null;
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBytes() {
        int n;
        int n2 = this.rawBytes.length;
        try {
            int n3;
            for (n = 0; n < n2; n += n3) {
                n3 = 0;
                AudioInputStream audioInputStream = this.ais;
                synchronized (audioInputStream) {
                    n3 = this.ais.read(this.rawBytes, n, n2 - n);
                }
                if (n3 != -1) continue;
                this.system.debug("Actual read was -1, pausing...");
                this.pause();
                break;
            }
        }
        catch (IOException iOException) {
            this.system.error("Error reading from the file - " + iOException.getMessage());
        }
        this.totalBytesRead += n;
    }

    private void readBytesLoop() {
        int n = this.loopEnd - this.totalBytesRead;
        if (n <= 0) {
            this.setMillisecondPosition(this.loopBegin);
            this.readBytesLoop();
            return;
        }
        if (n < this.rawBytes.length) {
            this.readBytesWrap(n, 0);
            if (this.loop && this.numLoops == 0) {
                this.loop = false;
                this.pause();
            } else if (this.loop) {
                this.setMillisecondPosition(this.loopBegin);
                this.readBytesWrap(this.rawBytes.length - n, n);
                if (this.numLoops != -1) {
                    --this.numLoops;
                }
            }
        } else {
            this.readBytesWrap(this.rawBytes.length, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBytesWrap(int n, int n2) {
        int n3 = 0;
        try {
            while (n3 < n) {
                int n4 = 0;
                AudioInputStream audioInputStream = this.ais;
                synchronized (audioInputStream) {
                    n4 = this.ais.read(this.rawBytes, n3 + n2, n - n3);
                }
                if (-1 == n4) {
                    this.setMillisecondPosition(0);
                    continue;
                }
                if (n4 != 0) {
                    n3 += n4;
                    this.totalBytesRead += n4;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            this.system.error("Error reading from the file - " + iOException.getMessage());
        }
    }

    private void writeBytes() {
        int n = this.rawBytes.length - this.bytesWritten;
        int n2 = this.line.write(this.rawBytes, this.bytesWritten, n);
        if (n2 != n) {
            this.system.debug("writeBytes: wrote " + n2 + " of " + n);
            this.shouldRead = false;
            this.bytesWritten += n2;
        } else {
            this.shouldRead = true;
            this.bytesWritten = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast() {
        FloatSampleBuffer floatSampleBuffer = this.buffer;
        synchronized (floatSampleBuffer) {
            if (this.buffer.getChannelCount() == 1) {
                if (this.play) {
                    this.listener.samples(this.buffer.getChannel(0));
                } else {
                    this.listener.samples(this.silence);
                }
            } else if (this.buffer.getChannelCount() == 2) {
                if (this.play) {
                    this.listener.samples(this.buffer.getChannel(0), this.buffer.getChannel(1));
                } else {
                    this.listener.samples(this.silence, this.silence);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void process() {
        FloatSampleBuffer floatSampleBuffer = this.buffer;
        synchronized (floatSampleBuffer) {
            int n = this.rawBytes.length / this.format.getFrameSize();
            this.buffer.setSamplesFromBytes(this.rawBytes, 0, this.format, 0, n);
            if (this.buffer.getChannelCount() == 1) {
                this.effect.process(this.buffer.getChannel(0));
            } else if (this.buffer.getChannelCount() == 2) {
                this.effect.process(this.buffer.getChannel(0), this.buffer.getChannel(1));
            }
            this.buffer.convertToByteArray(this.rawBytes, 0, this.format);
        }
    }

    public void play() {
        this.line.start();
        this.loop = false;
        this.numLoops = 0;
        this.play = true;
    }

    public boolean isPlaying() {
        return this.play;
    }

    public void pause() {
        this.line.stop();
        this.play = false;
    }

    public void loop(int n) {
        this.setMillisecondPosition(this.loopBegin);
        this.loop = true;
        this.numLoops = n;
        this.play = true;
        this.line.start();
    }

    public void open() {
        this.finished = false;
        this.iothread = new Thread(this);
        this.iothread.start();
    }

    public void close() {
        this.finished = true;
        this.iothread = null;
        try {
            this.ais.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ais = null;
        this.line.flush();
        this.line.close();
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getLoopCount() {
        return this.numLoops;
    }

    public void setLoopPoints(int n, int n2) {
        this.loopBegin = n <= 0 || n > n2 ? 0 : n;
        this.loopEnd = n2 <= this.getMillisecondLength() && n2 > n ? (int)AudioUtils.millis2BytesFrameAligned((long)n2, (AudioFormat)this.format) : (int)AudioUtils.millis2BytesFrameAligned((long)this.getMillisecondLength(), (AudioFormat)this.format);
    }

    public int getMillisecondPosition() {
        return (int)AudioUtils.bytes2Millis((long)this.totalBytesRead, (AudioFormat)this.format);
    }

    public void setMillisecondPosition(int n) {
        boolean bl = this.play;
        this.play = false;
        if (n < this.getMillisecondPosition()) {
            this.rewind();
            this.totalBytesRead = this.skip(n);
        } else {
            this.totalBytesRead += this.skip(n - this.getMillisecondPosition());
        }
        this.play = bl;
    }

    public long getSampleFrameLength() {
        return this.ais.getFrameLength();
    }

    public Control[] getControls() {
        return this.line.getControls();
    }

    public void setAudioEffect(AudioEffect audioEffect) {
        this.effect = audioEffect;
    }

    public void setAudioListener(AudioListener audioListener) {
        this.listener = audioListener;
    }

    protected synchronized void rewind() {
        try {
            this.ais.close();
        }
        catch (IOException iOException) {
            this.system.error("JSPCMAudioRecordingStream::rewind - Error closing the stream before reload: " + iOException.getMessage());
        }
        this.ais = this.system.getAudioInputStream(this.meta.fileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int skip(int n) {
        long l = AudioUtils.millis2BytesFrameAligned((long)n, (AudioFormat)this.format);
        if (l <= 0L) {
            if (l < 0L) {
                this.system.error("JSBaseAudioRecordingStream.skip :: Tried to skip negative milleseconds!");
            }
            return 0;
        }
        this.system.debug("Skipping forward by " + n + " milliseconds, which is " + l + " bytes.");
        long l2 = 0L;
        try {
            while (l > 0L) {
                long l3;
                AudioInputStream audioInputStream = this.ais;
                synchronized (audioInputStream) {
                    int n2 = this.skipBytes.length;
                    if (l < (long)n2) {
                        n2 = (int)l;
                    }
                    l3 = this.ais.read(this.skipBytes, 0, n2);
                }
                if (l3 == -1L) {
                    this.system.debug("JSBaseAudioRecordingStream.skip :: EOF reached!");
                    break;
                }
                l -= l3;
                l2 += l3;
            }
        }
        catch (IOException iOException) {
            this.system.error("Unable to skip due to read error: " + iOException.getMessage());
        }
        this.system.debug("Total actually skipped was " + l2 + ", which is " + AudioUtils.bytes2Millis((long)l2, (AudioFormat)this.ais.getFormat()) + " milliseconds.");
        return (int)l2;
    }

    public float[] read() {
        if (this.buffer.getSampleCount() != 1) {
            this.buffer.changeSampleCount(1, true);
            this.rawBytes = new byte[this.buffer.getByteArrayBufferSize(this.format)];
        }
        float[] fArray = new float[this.buffer.getChannelCount()];
        if (this.play) {
            this.mRead();
            for (int i = 0; i < this.buffer.getChannelCount(); ++i) {
                fArray[i] = this.buffer.getChannel(i)[0];
            }
        }
        return fArray;
    }

    public void read(MultiChannelBuffer multiChannelBuffer) {
        if (this.buffer.getSampleCount() != multiChannelBuffer.getBufferSize()) {
            this.buffer.changeSampleCount(multiChannelBuffer.getBufferSize(), true);
            this.rawBytes = new byte[this.buffer.getByteArrayBufferSize(this.format)];
        }
        if (this.play) {
            this.mRead();
        } else {
            this.buffer.makeSilence();
        }
        for (int i = 0; i < this.buffer.getChannelCount(); ++i) {
            multiChannelBuffer.setChannel(i, this.buffer.getChannel(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mRead() {
        if (this.loop) {
            this.readBytesLoop();
        } else {
            this.readBytes();
        }
        FloatSampleBuffer floatSampleBuffer = this.buffer;
        synchronized (floatSampleBuffer) {
            int n = this.rawBytes.length / this.format.getFrameSize();
            this.buffer.setSamplesFromBytes(this.rawBytes, 0, this.format, 0, n);
        }
    }
}

