/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioSignal;
import java.util.HashSet;
import java.util.Vector;

public class SignalChain
implements AudioSignal {
    private Vector<AudioSignal> signals = new Vector();
    private Vector<AudioSignal> signalsToRemove = new Vector();
    private HashSet<AudioSignal> enabled = new HashSet();
    private float[] tmpL;
    private float[] tmpR;

    public synchronized void add(AudioSignal audioSignal) {
        this.signals.add(audioSignal);
        this.enabled.add(audioSignal);
    }

    public synchronized void remove(AudioSignal audioSignal) {
        this.signalsToRemove.add(audioSignal);
    }

    public synchronized AudioSignal remove(int n) {
        AudioSignal audioSignal = this.signals.remove(n);
        this.enabled.remove(audioSignal);
        return audioSignal;
    }

    public synchronized AudioSignal get(int n) {
        return this.signals.get(n);
    }

    public synchronized boolean contains(AudioSignal audioSignal) {
        return this.signals.contains(audioSignal);
    }

    public synchronized void enable(int n) {
        this.enabled.add(this.get(n));
    }

    public synchronized void enable(AudioSignal audioSignal) {
        if (this.signals.contains(audioSignal)) {
            this.enabled.add(audioSignal);
        }
    }

    public synchronized void enableAll() {
        this.enabled.addAll(this.signals);
    }

    public synchronized boolean hasEnabled() {
        return this.enabled.size() > 0;
    }

    public synchronized boolean isEnabled(AudioSignal audioSignal) {
        return this.enabled.contains(audioSignal);
    }

    public synchronized void disable(int n) {
        this.enabled.remove(this.get(n));
    }

    public synchronized void disable(AudioSignal audioSignal) {
        this.enabled.remove(audioSignal);
    }

    public synchronized void disableAll() {
        this.enabled.clear();
    }

    public synchronized int size() {
        return this.signals.size();
    }

    public synchronized void clear() {
        this.signals.clear();
        this.enabled.clear();
    }

    @Override
    public synchronized void generate(float[] fArray) {
        if (this.tmpL == null) {
            this.tmpL = new float[fArray.length];
        }
        for (int i = 0; i < this.signals.size(); ++i) {
            int n;
            AudioSignal audioSignal = this.signals.get(i);
            if (!this.enabled.contains(audioSignal)) continue;
            for (n = 0; n < this.tmpL.length; ++n) {
                this.tmpL[n] = 0.0f;
            }
            audioSignal.generate(this.tmpL);
            for (n = 0; n < fArray.length; ++n) {
                int n2 = n;
                fArray[n2] = fArray[n2] + this.tmpL[n];
            }
        }
        this.signals.removeAll(this.signalsToRemove);
        this.signalsToRemove.removeAllElements();
    }

    @Override
    public synchronized void generate(float[] fArray, float[] fArray2) {
        if (this.tmpL == null) {
            this.tmpL = new float[fArray.length];
        }
        if (this.tmpR == null) {
            this.tmpR = new float[fArray2.length];
        }
        for (int i = 0; i < this.signals.size(); ++i) {
            AudioSignal audioSignal = this.signals.get(i);
            if (!this.enabled.contains(audioSignal)) continue;
            audioSignal.generate(this.tmpL, this.tmpR);
            for (int j = 0; j < fArray.length; ++j) {
                int n = j;
                fArray[n] = fArray[n] + this.tmpL[j];
                int n2 = j;
                fArray2[n2] = fArray2[n2] + this.tmpR[j];
            }
        }
        this.signals.removeAll(this.signalsToRemove);
        this.signalsToRemove.removeAllElements();
    }
}

