/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.PrintWriter;
import java.util.HashMap;
import processing.core.PApplet;
import processing.data.Sort;

public class FloatHash {
    public int count;
    protected String[] keys;
    protected float[] values;
    private HashMap<String, Integer> indices = new HashMap();

    public FloatHash() {
        this.count = 0;
        this.keys = new String[10];
        this.values = new float[10];
    }

    public FloatHash(int length) {
        this.count = 0;
        this.keys = new String[length];
        this.values = new float[length];
    }

    public FloatHash(PApplet parent, String filename) {
        String[] lines = parent.loadStrings(filename);
        this.keys = new String[lines.length];
        this.values = new float[lines.length];
        int i = 0;
        while (i < lines.length) {
            String[] pieces = PApplet.split(lines[i], '\t');
            if (pieces.length == 2) {
                this.keys[this.count] = pieces[0];
                this.values[this.count] = PApplet.parseFloat(pieces[1]);
                ++this.count;
            }
            ++i;
        }
    }

    public int getCount() {
        return this.count;
    }

    public String key(int index) {
        return this.keys[index];
    }

    protected void crop() {
        if (this.count != this.keys.length) {
            this.keys = PApplet.subset(this.keys, 0, this.count);
            this.values = PApplet.subset(this.values, 0, this.count);
        }
    }

    public String[] keys() {
        this.crop();
        return this.keys;
    }

    public String[] keyArray() {
        return this.keyArray(null);
    }

    public String[] keyArray(String[] outgoing) {
        if (outgoing == null || outgoing.length != this.count) {
            outgoing = new String[this.count];
        }
        System.arraycopy(this.keys, 0, outgoing, 0, this.count);
        return outgoing;
    }

    public float value(int index) {
        return this.values[index];
    }

    public float[] values() {
        this.crop();
        return this.values;
    }

    public int[] valueArray() {
        int[] outgoing = new int[this.count];
        System.arraycopy(this.values, 0, outgoing, 0, this.count);
        return outgoing;
    }

    public float get(String what) {
        int index = this.index(what);
        if (index == -1) {
            return 0.0f;
        }
        return this.values[index];
    }

    public void set(String who, int amount) {
        int index = this.index(who);
        if (index == -1) {
            this.create(who, amount);
        } else {
            this.values[index] = amount;
        }
    }

    public void add(String who, int amount) {
        int index = this.index(who);
        if (index == -1) {
            this.create(who, amount);
        } else {
            int n = index;
            this.values[n] = this.values[n] + (float)amount;
        }
    }

    public void increment(String who) {
        int index = this.index(who);
        if (index == -1) {
            this.create(who, 1);
        } else {
            int n = index;
            this.values[n] = this.values[n] + 1.0f;
        }
    }

    public int index(String what) {
        Integer found = this.indices.get(what);
        return found == null ? -1 : found;
    }

    protected void create(String what, int much) {
        if (this.count == this.keys.length) {
            this.keys = PApplet.expand(this.keys);
            this.values = PApplet.expand(this.values);
        }
        this.indices.put(what, new Integer(this.count));
        this.keys[this.count] = what;
        this.values[this.count] = much;
        ++this.count;
    }

    public void print() {
        this.write(new PrintWriter(System.out));
    }

    public void write(PrintWriter writer) {
        int i = 0;
        while (i < this.count) {
            writer.println(String.valueOf(this.keys[i]) + "\t" + this.values[i]);
            ++i;
        }
        writer.flush();
    }

    public void remove(String which) {
        this.removeIndex(this.index(which));
    }

    public void removeIndex(int which) {
        this.indices.remove(this.keys[which]);
        int i = which;
        while (i < this.count - 1) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
            this.indices.put(this.keys[i], i);
            ++i;
        }
        --this.count;
        this.keys[this.count] = null;
        this.values[this.count] = 0.0f;
    }

    public void swap(int a, int b) {
        String tkey = this.keys[a];
        float tvalue = this.values[a];
        this.keys[a] = this.keys[b];
        this.values[a] = this.values[b];
        this.keys[b] = tkey;
        this.values[b] = tvalue;
        this.indices.put(this.keys[a], new Integer(a));
        this.indices.put(this.keys[b], new Integer(b));
    }

    public void sortKeys() {
        Sort s = new Sort(){

            @Override
            public int size() {
                return FloatHash.this.count;
            }

            @Override
            public float compare(int a, int b) {
                int result = FloatHash.this.keys[a].compareToIgnoreCase(FloatHash.this.keys[b]);
                if (result != 0) {
                    return result;
                }
                return FloatHash.this.values[b] - FloatHash.this.values[a];
            }

            @Override
            public void swap(int a, int b) {
                FloatHash.this.swap(a, b);
            }
        };
        s.run();
    }

    public void sortValues() {
        this.sortValues(true, true);
    }

    public void sortValues(boolean descending) {
        this.sortValues(descending, true);
    }

    public void sortValues(final boolean descending, final boolean tiebreaker) {
        Sort s = new Sort(){

            @Override
            public int size() {
                return FloatHash.this.count;
            }

            @Override
            public float compare(int a, int b) {
                float diff = FloatHash.this.values[b] - FloatHash.this.values[a];
                if (tiebreaker && diff == 0.0f) {
                    diff = FloatHash.this.keys[a].compareToIgnoreCase(FloatHash.this.keys[b]);
                }
                return descending ? diff : -diff;
            }

            @Override
            public void swap(int a, int b) {
                FloatHash.this.swap(a, b);
            }
        };
        s.run();
    }
}

