package com.geekparty.shooter.view.game {
	import com.geekparty.shooter.view.components.LifesView;
	import com.geekparty.shooter.view.game.bullets.HeroBullet;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.geom.Point;
	import flash.utils.Timer;
	
	/**
	 * ...
	 * @author Frost
	 */
	public class Hero extends Sprite {
		public var jumping:Boolean;
		public var movingBack:Boolean;
		
		private var layout:UI_hero;
		
		private var hand:MovieClip;
		
		private var jumpTimer:Timer;
		
		private var shootCenter:MovieClip;
		private var boom:MovieClip;
		
		public var life:int;
		
		public var collision:MovieClip;
		
		public function Hero() {
			initLayout();
			jumpTimer = new Timer(20);
			jumpTimer.addEventListener(TimerEvent.TIMER, onJumpTick);
			gravity = 1.5;
			waveNumber = 0;
			shootCoolDown = 20;
			life = 3;
			blinkTimer = new Timer(30);
			blinkTimes = blinks;
			blinkTimer.addEventListener(TimerEvent.TIMER, blink);
			weaponLevel = 0;
		}
		
		public var blinking:Boolean;
		
		private static const blinks:int = 30;
		
		private var blinkTimes:int;
		
		private function blink(e:TimerEvent):void {
			if (blinkTimes-- <= 0) {
				blinkTimer.stop();
				blinkTimer.reset();
				blinkTimes = blinks;
				visible = true;
				blinking = false;
				return;
			}
			visible = !visible;
		}
		
		private function onJumpComplete(e:TimerEvent):void {
			jumpTimer.stop();
			rotation = 0;
			jumping = false;
		}
		
		public function init(bullitGenerator:BulletGenerator, lifesView:LifesView):void {
			this.lifesView = lifesView;
			this.bulletGenerator = bullitGenerator;
		}
		
		private var gravity:Number;
		private var jumpVelocity:Number;
		
		private function onJumpTick(e:TimerEvent):void {
			jumpVelocity += gravity;
			layout.y += jumpVelocity;
			
			layout.rotation = jumpVelocity * (movingBack ? -1 : 1);
			
			if (layout.y > 0) {
				jumpTimer.stop();
				jumping = false;
				layout.rotation = 0;
				layout.y = 0;
			}
		}
		
		private function initLayout():void {
			layout = new UI_hero();
			hand = layout.getChildByName('hand') as MovieClip;
			boom = layout.getChildByName('boom') as MovieClip;
			collision = layout.getChildByName('collision') as MovieClip;
			boom.visible = false;
			shootCenter = hand.getChildByName('center') as MovieClip;
			addChild(layout);
		}
		
		public function moveHand(mx:Number, my:Number):void {
			var a1:Number = my - parent.localToGlobal(new Point(hand.x, hand.y)).y; // .y;
			var b1:Number = mx - parent.localToGlobal(new Point(hand.x, hand.y)).x;
			var radians1:Number = Math.atan2(a1, b1);
			var degrees1:Number = radians1 / (Math.PI / 180);
			hand.rotation = degrees1;
		}
		
		private var blinkTimer:Timer;
		
		public function damage():void {
			//blinking = true;
			if (blinking) {
				return;
			}
			life--;
			(new pain_sound()).play();
			weaponLevel = 0;
			lifesView.minusLife();
			if (life <= 0) {
				return;
			}
			blinking = true;
			blinkTimer.start();
		}
		
		public function die():void {
			var boat:MovieClip = layout.getChildByName('boat') as MovieClip;
			boat.visible = false;
			boom.visible = true;
			boom.gotoAndPlay(1);
			hand.visible = false;
			boom.addEventListener(Event.ENTER_FRAME, onFrame);
		}
		
		private function onFrame(e:Event):void {
			boom.alpha -= 0.01;
			if (boom.currentFrame == (boom.totalFrames - 1)) {
				boom.removeEventListener(Event.ENTER_FRAME, onFrame);
				boom.visible = false;
			}
		}
		
		public function jump(jumpPower:int):void {
			jumpVelocity = -jumpPower;
			jumping = true;
			jumpTimer.reset();
			jumpTimer.start();
		}
		
		private var bulletGenerator:BulletGenerator;
		private var waveNumber:Number;
		
		private var shootCoolDown:int;
		private var lifesView:LifesView;
		private var median:Boolean;
		
		public function wave():void {
			if (shootCoolDown > 0) {
				shootCoolDown--;
			}
			if (jumping) {
				rotation = -5;
			}
			var arg:Number = Math.sin(waveNumber) * 0.5;
			rotation = -5 + arg * 5;
			waveNumber += 0.3;
			if (waveNumber >= 60) {
				waveNumber = 0;
				y = 500;
			}
			y += arg;
		}
		
		public function shoot():void {
			if (shootCoolDown > 0) {
				return;
			}
			(new shoot_snd()).play();
			var startPoint:Point = localToGlobal(new Point(hand.x, hand.y));
			var endPoint:Point = new Point(stage.mouseX, stage.mouseY);
			var flyVector:Point = endPoint.subtract(startPoint);
			flyVector.normalize(1);
			var xpos:Number = hand.localToGlobal(new Point(shootCenter.x, shootCenter.y)).x;
			var ypos:Number = hand.localToGlobal(new Point(shootCenter.x, shootCenter.y)).y;
			
			var b:HeroBullet = new HeroBullet();
			b.flyVector = flyVector;
			
			b.x = xpos;
			b.y = ypos;
			
			if (weaponLevel ==  3) {
				var count:int = 5;
				var i:int;
				var t:Number;
				for (i = 0; i < count; i++) {
					t = Math.floor(i - count / 2) * 0.1;
					
					var bullet:HeroBullet = new HeroBullet();
					bullet.x = xpos;
					bullet.y = ypos;
					var _flyVector:Point = new Point(flyVector.x * Math.cos(t) - flyVector.y * Math.sin(t), flyVector.x * Math.sin(t) + flyVector.y * Math.cos(t));
					_flyVector.normalize(1);
					bullet.flyVector = _flyVector;
					bulletGenerator.generate(bullet);
				}
			}
			
			bulletGenerator.generate(b);
			switch (weaponLevel) {
				case 0:
					shootCoolDown = 10;
					break;
				case 1:
					shootCoolDown = 6;
					break;
				case 2:
					shootCoolDown = 3;
					break;
				case 3:
					shootCoolDown = 10;
					break;
			}
		}
		
		public function moveRight():void {
			layout.rotation = -15;
		}
		
		public function stand():void {
			layout.rotation = 0;
		}
		
		public function applyBonus(bonusType:int):void {
			switch (bonusType) {
				case 0:
					if (life == 4) {
						break;
					}
					life++;
					lifesView.plusLife();
					break;
				case 1: 
					weaponUpgrade();
					break;
			}
		}
		
		private var weaponLevel:int;
		
		private function weaponUpgrade():void {
			weaponLevel++;
			if (weaponLevel == 4) {
				weaponLevel = 0;
			}
		}
	}
}