package com.geekparty.shooter.view.game {
	
	/**
	 * ...
	 * @author Frost
	 */
	public class CollisionDetector {
		private var hero:Hero;
		private var enemies:Vector.<Enemy>;
		private var shakeScreen:Function;
		private var bullets:Vector.<Bullet>;
		private var flyingEnemies:Vector.<Enemy>;
		private var enemyBullets:Vector.<Bullet>;
		private var scoreView:ScoreView;
		private var bonuses:Vector.<Bonus>;
		
		public function CollisionDetector() {
		
		}
		
		public function init(enemies:Vector.<Enemy>
							, hero:Hero
							, shakeScreen:Function
							, bullets:Vector.<Bullet>
							, flyingEnemies:Vector.<Enemy>
							, enemyBullets:Vector.<Bullet>
							, scoreView:ScoreView
							, bonuses:Vector.<Bonus>):void {
			this.bonuses = bonuses;
			this.scoreView = scoreView;
			this.enemyBullets = enemyBullets;
			this.flyingEnemies = flyingEnemies;
			this.bullets = bullets;
			this.shakeScreen = shakeScreen;
			this.enemies = enemies;
			this.hero = hero;
		}
		
		public function tick():void {
			var i:int;
			if (!hero.blinking) {
				for (i = 0; i < enemies.length; i++) {
					if (hero.collision.hitTestObject(enemies[i].hit_area)) {
						(new ponastavily()).play();
						scoreView.plus(enemies[i].getScore());
						enemies[i].destroy();
						hero.damage();
						shakeScreen();
						break;
					}
				}
			}
			
			var j:int;
			
			for (i = 0; i < bullets.length; i++) {
				for (j = 0; j < bonuses.length; j++) {
					if (bonuses[j].closed) { 
						if (bullets[i].hitTestObject(bonuses[j].hit_area)) {
							bonuses[j].onShoot();
						}
					}
				}
			}
			
			for (i = 0; i < bonuses.length; i++) {
				if (!bonuses[i].closed) { 
					if (hero.collision.hitTestObject(bonuses[i].hit_area)) {
						hero.applyBonus(bonuses[i].type);
						bonuses[i].destroy();
					}
				}
			}
			
			
			for (i = 0; i < bullets.length; i++) {
				for (j = 0; j < flyingEnemies.length; j++) {
					if (bullets[i].hitTestObject(flyingEnemies[j])) {
						if (flyingEnemies[j].damage(bullets[i].damage)) {
							scoreView.plus(flyingEnemies[j].getScore());
							flyingEnemies[j].destroy();
							shakeScreen();
						}
						bullets[i].destroy();
						break;
					}
				}
			}
			for (i = 0; i < bullets.length; i++) {
				for (j = 0; j < enemies.length; j++) {
					if (bullets[i].hitTestObject(enemies[j])) {
						if (enemies[j].damage(bullets[i].damage)) {
							shakeScreen();
						}
						bullets[i].destroy();
						break;
					}
				}
			}
			
			if (!hero.blinking) {
				for (i = 0; i < enemyBullets.length; i++) {
					if (hero.collision.hitTestObject(enemyBullets[i])) {
						(new proklyatie_ptichki()).play();
						enemyBullets[i].destroy();
						hero.damage();
						shakeScreen();
						break;
					}
				}
			}
		}
	}
}