
function rgb(r, g, b) {
    return "#" + (r.toString(16)) + (g.toString(16)) + (b.toString(16));
}

function drawCircle(x, y, r, context) {
    context.beginPath();
    context.arc(x, y, r, 0, 2 * Math.PI, false);
    context.stroke();
    context.fill();
}

Star.prototype.repaint = function(context) {
    context.fillStyle = this.color;
    drawCircle(this.position.x, this.position.y, 2, context);
};

Liner.prototype.repaint = function(context) {
    context.fillStyle = 'yellow';
    context.fillText(this.armor, this.position.x - 10, this.getBounds().a.y - 6);
    drawPoly(shapes.triangle, this.position, this.radius,
	     Math.atan2(this.direction.y, this.direction.x), context);
    context.fill();
};

Homing.prototype.repaint = function(context) {
    
    var pos = this.position;
    var dir = norm(this.direction);
    context.strokeStyle = "#0000FF";
    context.beginPath();
    context.moveTo(pos.x, pos.y);
    context.lineTo(pos.x + this.length * dir.x,
            pos.y + this.length * dir.y);
    context.stroke();
};

Bullet.prototype.repaint = function(context) {
    context.fillStyle = '#00FF00';
    drawCircle(this.position.x, this.position.y, this.radius, context);
    context.fill();
};

Ship.prototype.repaint = function(context) {
    var bounds = this.getBounds();
    var hmiddle = 70;
    var wmiddle = bounds.width / 2;
        
    if (this.direction.y < 0) {
        hmiddle = 60;
    } else if (this.direction.y > 0) {
        hmiddle = 80;
    }
    if (this.direction.x < 0) {
        context.fillStyle = '#660000';
        wmiddle = bounds.width / 2 - 5;
    } else if (this.direction.x > 0) {
        context.fillStyle = '#FF0000';
        wmiddle = bounds.width / 2 + 5;
    } else {
        context.fillStyle = '#AA0000';
        wmiddle = bounds.width / 2;
    }
    //left
    context.strokeStyle = context.fillStyle;
    context.beginPath();
    context.moveTo(bounds.a.x + wmiddle, bounds.a.y);
    context.lineTo(bounds.a.x, bounds.a.y + hmiddle);
    context.lineTo(bounds.a.x + wmiddle, bounds.b.y);
    context.lineTo(bounds.a.x + wmiddle, bounds.a.y);
    context.stroke();
    context.fill();
    
    //right
    if (this.direction.x > 0) {
        context.fillStyle = '#AA0000';
    } else if (this.direction.x < 0) {
        context.fillStyle = '#FF0000';
    } else {
        context.fillStyle = '#FF0000';
    }
    
    context.strokeStyle = context.fillStyle;    
    context.beginPath();
    context.moveTo(bounds.a.x + wmiddle, bounds.a.y);
    context.lineTo(bounds.b.x, bounds.a.y + hmiddle);
    context.lineTo(bounds.a.x + wmiddle, bounds.b.y);
    context.lineTo(bounds.a.x + wmiddle, bounds.a.y);
    context.stroke();
    context.fill();
    context.fillText(this.armor + "/" + this.frags + "/" + this.weapon.level, this.position.x - 10, this.getBounds().a.y - 6);
};

Obstacle.prototype.repaint = function(context){
    context.fillStyle = this.color;
    context.strokeStyle = this.color;
    drawPoly(this.shape, this.position, this.radius * 2, this.alpha, context);
    context.fill();
}

function drawPoly(poly, position, radius, rotation, context){
    context.beginPath();
    var p = rotate(poly[0], v(0, 0), rotation);
    context.moveTo(position.x + radius * p.x,
		   position.y + radius * p.y);
    for (var i = 1; i < poly.length; i++){
        var p = rotate(poly[i], v(0, 0), rotation);
        context.lineTo(position.x + radius * p.x, position.y + radius * p.y);
    }
    context.stroke();
}