      uniform sampler2D     bgTexture;
      uniform sampler2D     textTexture;
      uniform sampler2D     cloudsTexture;
      uniform sampler2D     spriteTexture;
      uniform sampler2D     world2Texture;
      uniform sampler2D     starsTexture;
      
      uniform float frameCount;
	  
	  uniform float fade;  
	  
	  uniform float camera_x;
	  uniform float camera_y;
	  uniform float camera_z;
	  uniform float camera_yaw;
	  uniform float camera_roll;
	  uniform float camera_pitch;
	  
	  uniform float text_opacity;
	  uniform float text_v;      
	  
	  uniform float skytime;
	  
	  uniform float worldtype;
	  
	  uniform float spriteFrame;
	  
	  uniform float spriteRotate;
	  
	  uniform float g_mosaic;  
	  uniform float g_sepia;  
 

      //#define TEX2D(c) texture2D(bgTexture,(c))
      
      vec4 TEX2D(vec2 c) {
	  	if(worldtype == 1) {
		  	return texture2D(world2Texture, c);
		}
		else {
			return texture2D(bgTexture, c);
		}
	  }

      #define PI 3.14159265
      
      #define R(p, a) p=cos(a)*p+sin(a)*vec2(p.y,-p.x)
      
      
      const vec3 sky1a = vec3(0, 0, 52);
      const vec3 sky1b = vec3(0, 53, 74);
      const vec3 sky2a = vec3(216, 246, 126);
      const vec3 sky2b = vec3(253, 92, 9);
      const vec3 sky3a = vec3(11, 100, 211);
      const vec3 sky3b = vec3(11, 198, 253);
      

      void main()
      {
        mat3x3 rgb2yuv = mat3x3(0.299,-0.14713, 0.615,
                 0.587,-0.28886,-0.51499,
                 0.114, 0.436  ,-0.10001);
        mat3x3 yuv2rgb = mat3x3(1.0, 1.0, 1.0,
                 0.0,-0.39465,2.03211,
                 1.13983,-0.58060,0.0);
                 
      	vec2 xy = gl_TexCoord[0].xy;
      	
      	if(g_mosaic > 1.0) {
			xy = floor(g_mosaic*xy)/g_mosaic;  
		}
      	
      	xy.y = 1.0 - xy .y;
	
		vec4 frag;
		
		
		vec4 textfrag = texture2D(textTexture, xy * vec2(1,256.0/4096.0) + vec2(0, text_v/4096.0));
		//if(textfrag == vec4(1,0,0,1)) textfrag = vec4(0,0,0,0);
		if(xy.y > 0.5) textfrag = vec4(0,0,0,0);
		
		
		
		xy -= vec2(0.5, 0.5);
		R(xy, camera_roll * PI);
		xy += vec2(0.5, 0.5);
		
		
		
		vec3 rd = vec3(xy - vec2(0.5,0.45), 0.6);
		
		R(rd.zy, -camera_pitch * PI);
		
		R(rd.xz, camera_yaw * PI);
		
		
		
		xy.y += tan(camera_pitch * 2 + camera_y*0.05); // whatever??
	
		
		if(xy.y < 0.5) {
			float tod = fract(clamp(skytime,0,0.99));
			vec3 sky0 = vec3(0,0,0);
			vec3 sky1 = rgb2yuv * mix(sky1a, sky1b, 2 * xy.y) / 255.0;
			vec3 sky2 = rgb2yuv * mix(sky2a, sky2b, 2 * xy.y) / 255.0;
			vec3 sky3 = rgb2yuv * mix(sky3a, sky3b, 2 * xy.y) / 255.0;
			frag.a = 1;
			if(tod < 0.25) {
				frag.rgb = mix(sky3, sky0, 4.0 * (tod-0));
				
				
			}
			else if(tod < 0.5) {
				frag.rgb = mix(sky0, sky1, 4.0 * (tod-0.25));
			}
			else if(tod < 0.75) {
				frag.rgb = mix(sky1, sky2, 4.0 * (tod-0.50));
			}
			else if(tod < 1.50) {
				frag.rgb = mix(sky2, sky3, 4.0 * clamp(tod-0.75,0.0,0.25));
			}
			//frag.r = tod*0.65;
			frag.rgb = yuv2rgb * frag.rgb;
			
			vec4 sky = frag;
			// sun
			frag.rgb += (pow(0.95 + length(xy - vec2(0.5 - 1*camera_yaw + 1, 0.9-0.6*skytime )), -990.0) )*vec3(2,0.1,0.1);
			
			
			// haze
			
			//frag = vec4(0.25,0.24,0.7,1) + xy.y * vec4(0.2,0.6,0.8,0);
			frag.rgb += 0.5*vec3(0.5,0.6,1.0) * (smoothstep(0.25,0.5,xy.y)*smoothstep(0.45,0.5,xy.y));
			
			frag.rgb = clamp(frag.rgb, 0, 1);
			
			// stars
			//frag.rgb += (1 - smoothstep(  0, 0.6, length(frag.rgb) )) * vec3(0.7,0.7,0.7) * clamp(125*pow(sin(sin(xy.x*356*sin(xy.x*1024+xy.y*128)+xy.y*128)+xy.y*512+frameCount*0.0001)*0.5+sin(xy.x*768*sin(xy.x*xy.y)*1000+frameCount*0.00005)*0.5, 1024), 0, 1);
			frag.rgb += (1 - smoothstep(  0, 0.66, length(frag.rgb) )) * vec3(0.9,0.9,0.9) * 1.6*  texture2D(starsTexture, xy - 0.9*vec2(camera_yaw, camera_pitch)).rgb;
			
			vec4 cloudFrag = texture2D(cloudsTexture, 2*(xy + vec2(frameCount*0.0002 + camera_yaw,-0.1))*vec2(0.5,2));
			if(xy.y > 0.35 || xy.y < 0.1) cloudFrag.a = 0;
			vec3 underlight = 2*sky.rgb * (1 - cloudFrag.r);
			
			cloudFrag.rgb *= pow(clamp(skytime,0,1.2),3) * 0.56;
			
			cloudFrag.rgb += underlight * smoothstep(tod, 0, 0.25);
			
			frag.rgb += cloudFrag.rgb * cloudFrag.a - frag.rgb * (cloudFrag.a);
			
			frag.rgb = clamp(frag.rgb, 0, 1);
			
			if(skytime > 2) {
				frag.rgb -= 0.2;
				frag.r += 0.9*pow(frag.b, 3);
				frag.g += 0.2*pow(frag.b, 6);
			}
		}
		else {

			float h = 0.51 + camera_y;
			
			
			
			float distance = (1.0 - xy.y ) * ( xy.y - 0.5 ) / 0.001;
			float scale = 1.8 * distance / 16;
			vec2 origin = vec2(12.6 + camera_x, 12*camera_z /* / 4096.0 */ );
				
			vec2 uv = vec2(h * rd.x / rd.y + origin.x, h * rd.z / rd.y + origin.y);
			
			//frag = TEX2D(0.5 + (scale*(xy - 0.5) - origin)/16 );
			frag = TEX2D(uv/56.0);
			
			//frag += 0.2*sin(0.7*uv.x*uv.y*sin(uv.y/4-uv.x/5)*0.5-sin(uv.y*0.5)*2.5 + frameCount/60);
			 
			 //water
			if(length(frag - vec4(0,0.4,0.6,1)) < 0.44) {
				frag = TEX2D(uv/56.0 + vec2(floor(3*sin(frameCount*0.01 + sin(uv.y*56) + 56*floor(frameCount/56.0+1*uv.y*4096.0/56)/4096.0))/4096.0, 0) );
			//	frag.r = 1;
			}
			
			if(worldtype == 2.0) {
				vec2 square = floor(2*mod( uv*4096/4096.0,1.0))*0.5;
				frag = mix(vec4(0.6,0.6,0.7,1),vec4(0.9,0.15,0.1,1), floor( mod(square.x + square.y - 0.5,2.0)*2 ) );
				frag = clamp(frag,0,1); 
			}
			
			if(worldtype == 3.0 && frag.r < 0.70) {
				frag.rgb += vec3(0.5+0.5*sin(xy.y*5 + frameCount/20.0),0.5+0.5*sin(xy.y*5 + PI/3 + frameCount/20.0),0.5+0.5*sin(xy.y*5 + PI/3 + PI/3 + frameCount/20.0))*0.3 - frag.rgb*0.8;
			}
			
			// haze
			frag.rgb += 0.5*vec3(0.5,0.6,1.0) * (1.0 - 1.0*smoothstep(0.5,0.53,xy.y)*smoothstep(0.5,0.55,xy.y));
			frag.rgb += vec3(0.5,0.5,1.0) * (1.0 - 1.0*smoothstep(0.5,0.9,xy.y)*smoothstep(0.5,0.55,xy.y));
			frag.rgb += vec3(0.7,0.5,1.0) * 0.12;
			
			frag.rgb *= pow(clamp(skytime,0,1),3);
		}
		
		
		float spriteU = -48/256.0 * spriteFrame + 87/256.0 * (1-spriteFrame);
		vec2 spriteUV = 2*xy - vec2(0.5, 0.5) - vec2(spriteU, (4*sin(frameCount*0.1)*spriteFrame + 54)/256.0);
		if(spriteFrame == 0 && spriteRotate == 1) {
			R(spriteUV, PI*0.5);
			spriteUV.y *= 1.07;
			spriteUV.y += 0.56;
			spriteUV.x += 4*sin(frameCount*0.1)/256.0;
			spriteUV.x -= 40.0/256;
		}
		
		if(spriteRotate >= 3.0) {
			spriteUV.y -= (spriteRotate - 4.0)*8.0;
		}

		vec4 spriteFrag = texture2D(spriteTexture, spriteUV );
		
		if(spriteRotate >= 3.0)
			spriteFrag.rgb /= pow(clamp(skytime,0,1),9 * (4-spriteRotate));


			spriteFrag.rgb *= pow(clamp(skytime,0,1),3);
		
		if((spriteFrame == 0 && spriteUV.x < 0.5) || (spriteFrame == 1 && spriteUV.x > 0.5))
			frag.rgb += spriteFrag.rgb * spriteFrag.a - frag.rgb * (spriteFrag.a);
		
		
		if(worldtype == 1.0) {
			frag.rgb += texture2D(starsTexture, xy*0.5 + vec2(camera_yaw + cos(camera_yaw)*frameCount/1000.0 + 0.01*sin(xy.y*9 + frameCount/200.0), camera_pitch - frameCount/600.0) );
		}
		

		frag.rgb += text_opacity * textfrag.rgb * textfrag.a - frag.rgb * text_opacity * textfrag.a;

		frag.rgb -= (1.0 - fade);
		frag.rgb *= fade;
		
		if(g_sepia > 0.0) {
			frag.r = length(frag.rgb);
			frag.rgb = frag.rrr;
			frag.rgb *= vec3(0.66,0.50,0.28)*0.9;
			frag.g -= 0.05;
			frag.rgb = clamp(frag.rgb,0.0,1.0);
		}
        gl_FragColor = vec4(frag);

      }
 

    
    