#version 330

layout( location = 0 ) in vec3 InVertex;
layout( location = 1 ) in vec3 InNormal;

out vec3 vNormal;
out vec3 vEye;

uniform mat4 ViewMatrix;
uniform mat4 ProjectionMatrix;
uniform mat4 ModelMatrix;

uniform float uSize;
uniform sampler2D uPosTex;

void main()
{
	float texelSize = 1.0 / uSize;
	float x = floor( mod( gl_InstanceID, uSize ) );
	float y = floor( gl_InstanceID / uSize );
	vec2 texCoord = vec2( x * texelSize, y * texelSize );
	
	vec3 pos = InVertex + ( texture( uPosTex, texCoord ).rgb * 2.0 - 1.0 );

	vEye = vec3( ( ViewMatrix * ModelMatrix ) * vec4( pos, 1.0 ) );
	vNormal = normalize( transpose( inverse( mat3( ViewMatrix * ModelMatrix ) ) ) * InNormal );
	gl_Position = ProjectionMatrix * ViewMatrix * ModelMatrix * vec4( pos, 1.0 );
}