#version 330

layout( location = 0 ) in vec2 InVertex;

out vec2 vTexCoordColor0;
out vec2 vTexCoordColor1;
out vec2 vTexCoordDepth0;
out vec2 vTexCoordDepth1;
out vec2 vTexCoordDepth2;
out vec2 vTexCoordDepth3;

uniform vec2 uInvRenderTargetSize;

void main()
{
	gl_Position = vec4( vec3( InVertex, 0.0 ), 1.0 );
	vec2 centerTexCoord = ( InVertex + 1.0 ) / 2.0;
	
	//Color
	vTexCoordColor0 = centerTexCoord + ( vec2( -1.0, -1.0 ) * uInvRenderTargetSize );
	vTexCoordColor1 = centerTexCoord + ( vec2( 1.0, -1.0 ) * uInvRenderTargetSize );
	
	//Depth
	vTexCoordDepth0 = centerTexCoord + ( vec2( -1.5, -1.5 ) * uInvRenderTargetSize );
	vTexCoordDepth1 = centerTexCoord + ( vec2( -0.5, -1.5 ) * uInvRenderTargetSize );
	vTexCoordDepth2 = centerTexCoord + ( vec2( 0.5, -1.5 ) * uInvRenderTargetSize );
	vTexCoordDepth3 = centerTexCoord + ( vec2( 1.5, -1.5 ) * uInvRenderTargetSize );
}