#version 330

in vec2 vTexCoordColor0;
in vec2 vTexCoordColor1;
in vec2 vTexCoordDepth0;
in vec2 vTexCoordDepth1;
in vec2 vTexCoordDepth2;
in vec2 vTexCoordDepth3;

layout( location = 0 ) out vec4 outColor;

uniform sampler2D uColorSampler;
uniform sampler2D uDepthSampler;

uniform float uZNear;
uniform float uZFar;

uniform vec2 uRowDelta;

//CoC Settings
uniform float uCoCBias;
uniform float uCoCScale;

float LinearizeDepth(float depth)
{
  return (2.0 * uZNear) / (uZFar + uZNear - depth * (uZFar - uZNear));	
}

void main()
{
	vec2 rowOffsets[4];
	rowOffsets[0] = vec2( 0.0 );
	rowOffsets[1] = uRowDelta;
	rowOffsets[2] = uRowDelta * 2.0;
	rowOffsets[3] = uRowDelta * 3.0;
	
	//CoC calculation storage
	vec4 depth = vec4( 0.0 );
	vec4 coc;
	vec4 currentCoc;
	
	//Color Sample
	vec3 color = vec3( 0.0 );
	color += texture( uColorSampler, vTexCoordColor0 + rowOffsets[0] ).rgb;
	color += texture( uColorSampler, vTexCoordColor1 + rowOffsets[0] ).rgb;
	color += texture( uColorSampler, vTexCoordColor0 + rowOffsets[2] ).rgb;
	color += texture( uColorSampler, vTexCoordColor1 + rowOffsets[2] ).rgb;
	color /= 4.0;
	
	//CoC Sample Row 0
	depth.x = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth0 + rowOffsets[0] ).r );
	depth.y = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth1 + rowOffsets[0] ).r );
	depth.z = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth2 + rowOffsets[0] ).r );
	depth.w = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth3 + rowOffsets[0] ).r );
	currentCoc = clamp( abs( depth * uCoCScale + uCoCBias ), 0.0, 1.0 );
	coc = currentCoc;
	
	//CoC Sample Row 1
	depth.x = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth0 + rowOffsets[1] ).r );
	depth.y = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth1 + rowOffsets[1] ).r );
	depth.z = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth2 + rowOffsets[1] ).r );
	depth.w = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth3 + rowOffsets[1] ).r );
	currentCoc = clamp( abs( depth * uCoCScale + uCoCBias ), 0.0, 1.0 );
	coc = max( coc, currentCoc );
	
	//CoC Sample Row 2
	depth.x = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth0 + rowOffsets[2] ).r );
	depth.y = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth1 + rowOffsets[2] ).r );
	depth.z = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth2 + rowOffsets[2] ).r );
	depth.w = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth3 + rowOffsets[2] ).r );
	currentCoc = clamp( abs( depth * uCoCScale + uCoCBias ), 0.0, 1.0 );
	coc = max( coc, currentCoc );
	
	//CoC Sample Row 3
	depth.x = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth0 + rowOffsets[3] ).r );
	depth.y = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth1 + rowOffsets[3] ).r );
	depth.z = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth2 + rowOffsets[3] ).r );
	depth.w = LinearizeDepth( texture( uDepthSampler, vTexCoordDepth3 + rowOffsets[3] ).r );
	currentCoc = clamp( abs( depth * uCoCScale + uCoCBias ), 0.0, 1.0 );
	coc = max( coc, currentCoc );
	
	float maxCoc = max( max( coc.x, coc.y ), max( coc.z, coc.w ) );
	
	outColor = vec4( color, maxCoc );
}