#version 330

in vec2 vTexCoord;

layout( location = 0 ) out vec4 outColor;

uniform sampler2D uTexSampler;
uniform float uHighPassCutoff;

void main()
{
	vec4 color = texture( uTexSampler, vTexCoord );
	float lum = sqrt( 0.241 * pow( color.r, 2 ) + 0.691 * pow( color.g, 2 ) + 0.068 * pow( color.b, 2 ) );
	if( lum > uHighPassCutoff )
	{
		outColor = color;
	}
	else
	{
		outColor = vec4( 0.0 );
	}
}