//Namespace
this.wideload = this.wideload || {};

/**
* Part 1 
*/

(function(){
	
	/**
	* Constructor
	* @param beginTime When the effect should start
	* @param prepareTime How long should the effect be allowed to stay in prepare phase (visible during previous parts end phase).
	         Value of 0 indicates immediate change. The endtime for previous part is the same as this parts prepare. First part has no prepare.
	*/
	var Part1 = function(beginTime, prepareTime, main){
		this.beginTime = beginTime;
		this.prepareTime = prepareTime;
		this.renderer = null; //Renderer is given from outside.
		this.main = main;
	}
	//Expose class
	wideload.Part1 = Part1;
	
	var p = Part1.prototype = new wideload.BasePart();
	
	/**
	* Initialize the part. This is called during page load.
	*/
	p.initialize = function(){
    	this.renderTarget = new THREE.WebGLRenderTarget(this.main.resolution[0], this.main.resolution[1]);
	
    this.maxX = this.main.resolution[0]/2;
    this.minX = -this.main.resolution[0]/2;
    this.maxY = this.main.resolution[1]/2;
    this.minY = -this.main.resolution[1]/2;
    
    this.scene = new THREE.Scene();
    this.camera = new THREE.OrthographicCamera(this.minX,
    this.maxX, this.maxY, this.minY);
	
    this.camera.position.z = 1;
    this.scene.add(this.camera);
	
    this.count = 0;
    this.random = wideload.Random;
    
    this.maxTriangleSize = Math.ceil(this.main.resolution[1]/10);
    
    this.geometries = [];
    
    this.lineGroup = new THREE.Object3D();
    this.scene.add(this.lineGroup);
   
	
	}
	
	/**
	* Prepare the part for coming up next. This is called when previous effect notifies the main controller it is ready to end.
	* @param previous Previous part.
	*/
	p.prepare = function(elapsedtime,previous){
		//tmn on tss siksi, ett Part2:n pallo erottuisi
		//taustasta paremmin.
    	this.main.renderer.setClearColor(0x000022);
	}
	
	
	/**
	* Previous effect has stopped playback. Start playback part.
	*/
	p.begin = function(elapsedtime){
	
	}
	
	/**
	* Pre render action if required
	*/
	p.preRender = function(elapsedtime){
    
    this.count++;
    
		if(this.count >3 && this.count%3 == 0){
    
      var geometry = new THREE.Geometry();

      //first vertices
      
      //TODO: TASOITA JAKAUMAA TRIGONOMETRISTEN FUNKTIOIDEN AVULLA JOTENKIN
      var x = Math.floor(this.random.nextFloat()*(this.maxX - this.minX)+this.minX);
      var y = Math.floor(this.random.nextFloat()*(this.maxY - this.minY)+this.minY);
      geometry.vertices.push(new THREE.Vector3(x, y, 0));
      
      var maxX = x + this.maxTriangleSize;
      var maxY = y + this.maxTriangleSize;
      var minX = x - this.maxTriangleSize;
      var minY = y - this.maxTriangleSize;
      
      //second vertices
      x = Math.floor(this.random.nextFloat()*(maxX - minX)+minX);
      y = Math.floor(this.random.nextFloat()*(maxY - minY)+minY);
      geometry.vertices.push(new THREE.Vector3(x, y, 0));
      
      //third vertices
      x = Math.floor(this.random.nextFloat()*(maxX - minX)+minX);
      y = Math.floor(this.random.nextFloat()*(maxY - minY)+minY);
      geometry.vertices.push(new THREE.Vector3(x, y, 0));
      
      //Tss kohtaa generoidaan viel yksi piste, mutta se tytyy laskea vhn
      //eri tavalla, jotta lopputuloksena on konveksi pinta.

      //last point is the same as the first.
      geometry.vertices.push(geometry.vertices[0].clone());
      geometry.computeBoundingBox();
      
      //TODO: OPTIMIZE!!
      for(var i = 0; i < this.geometries.length; ++i){
        if(geometry.boundingBox.isIntersectionBox(this.geometries[i].boundingBox)){
          //the geometry intersects, it can't be added to the scene
          geometry.dispose();
          return;
        }
      }
      //if the geometry didn't intersect it is accepted
      
      this.geometries.push(geometry);
      var line = new THREE.Line(geometry, new THREE.LineBasicMaterial({
        color : (0xFFFFFF*this.random.nextFloat()),
        linewidth : 40
      }));
      this.lineGroup.add(line);
    }
	}

	/**
	* Main controller calls render function
	* @param renderTarget The rendertarget to render to
	*/
	p.render = function(elapsedtime){
		this.main.renderer.render(this.scene, this.camera, this.renderTarget);
	}
	
	/**
	* Post render if required. Postprocessing actions can be done here for example.
	* @param renderTarget The rendertarget for final image. It is different than the one given in render-function.
	*/
	p.postRender = function(elapsedtime){
		
	}
	
	/**
	* Ending is near. Start animating ending if necessary
	* @param next part
	*/
	p.prepareEnd = function(elapsedtime,next){
		
	}

	/**
	* Order to end the part
	*/
	p.endPart = function(elapsedtime){
	
	}
	
}())